/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.ResponseTypeSet;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.ACRRequest;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import com.nimbusds.openid.connect.sdk.OIDCError;
import com.nimbusds.openid.connect.sdk.ResolveException;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class IDTokenClaimsRequest
extends ClaimsRequest {
    private int maxAge = 0;
    private final URL redirectURI;
    private final State state;

    public static Set<String> resolveRequiredClaims(ResponseTypeSet rts) {
        HashSet<String> claims = new HashSet<String>();
        claims.add("iss");
        claims.add("sub");
        claims.add("aud");
        claims.add("exp");
        claims.add("iat");
        if (rts.impliesImplicitFlow()) {
            claims.add("nonce");
        }
        if (rts.impliesImplicitFlow() && rts.contains(ResponseType.TOKEN)) {
            claims.add("at_hash");
        }
        if (rts.impliesImplicitFlow() && rts.contains(ResponseType.CODE)) {
            claims.add("c_hash");
        }
        return Collections.unmodifiableSet(claims);
    }

    public IDTokenClaimsRequest(ResponseTypeSet rts, JSONObject idTokenObject, URL redirectURI, State state) throws ResolveException {
        this.requiredClaims.addAll(IDTokenClaimsRequest.resolveRequiredClaims(rts));
        if (idTokenObject != null) {
            if (idTokenObject.containsKey((Object)"claims") && idTokenObject.get((Object)"claims") instanceof JSONObject) {
                JSONObject additionalClaims = (JSONObject)idTokenObject.get((Object)"claims");
                this.requestedClaims.putAll((Map)additionalClaims);
            }
            if (idTokenObject.get((Object)"max_age") != null && idTokenObject.get((Object)"max_age") instanceof Number) {
                this.maxAge = ((Number)idTokenObject.get((Object)"max_age")).intValue();
            }
        }
        this.redirectURI = redirectURI;
        this.state = state;
    }

    public Subject getRequiredSubject() throws ResolveException {
        Object subjectObject = this.requestedClaims.get((Object)"sub");
        if (subjectObject == null) {
            return null;
        }
        if (!(subjectObject instanceof Map)) {
            throw new ResolveException("Unexpected \"sub\" type, must be a JSON object", OIDCError.INVALID_OPENID_REQUEST_OBJECT, this.redirectURI, this.state, null);
        }
        Object subValue = ((Map)subjectObject).get("value");
        if (subValue == null) {
            return null;
        }
        if (!(subValue instanceof String)) {
            throw new ResolveException("Unexpected \"sub\" value type, must be a JSON string", OIDCError.INVALID_OPENID_REQUEST_OBJECT, this.redirectURI, this.state, null);
        }
        return new Subject((String)subValue);
    }

    public ACRRequest getRequestedACRs() throws ResolveException {
        Object acrObject = this.requestedClaims.get((Object)"acr");
        if (acrObject == null) {
            return null;
        }
        if (!(acrObject instanceof JSONObject)) {
            throw new ResolveException("Unexpected \"acr\" type, must be a JSON object", OIDCError.INVALID_OPENID_REQUEST_OBJECT, this.redirectURI, this.state, null);
        }
        Object acrValues = ((JSONObject)acrObject).get((Object)"values");
        Object essentialValue = ((JSONObject)acrObject).get((Object)"essential");
        if (acrValues == null) {
            return null;
        }
        if (!(acrValues instanceof List)) {
            throw new ResolveException("Unexpected \"acr\" values type, must be a JSON array", OIDCError.INVALID_OPENID_REQUEST_OBJECT, this.redirectURI, this.state, null);
        }
        ClaimRequirement req = ClaimRequirement.VOLUNTARY;
        if (essentialValue != null && essentialValue instanceof Boolean && ((Boolean)essentialValue).booleanValue()) {
            req = ClaimRequirement.ESSENTIAL;
        }
        int numElements = ((List)acrValues).size();
        ACR[] acr = new ACR[numElements];
        for (int i = 0; i < numElements; ++i) {
            if (!(((List)acrValues).get(i) instanceof String)) {
                throw new ResolveException("Unexpected ACR value, must be a JSON string", OIDCError.INVALID_OPENID_REQUEST_OBJECT, this.redirectURI, this.state, null);
            }
            acr[i] = new ACR((String)((List)acrValues).get(i));
        }
        return new ACRRequest(req, acr);
    }

    public int getRequiredMaxAge() throws ResolveException {
        return this.maxAge;
    }
}

