/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.ResponseTypeSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.Display;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCError;
import com.nimbusds.openid.connect.sdk.OIDCResponseType;
import com.nimbusds.openid.connect.sdk.OIDCScopeToken;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class OIDCAuthorizationRequest
extends AuthorizationRequest {
    private final Nonce nonce;
    private final Display display;
    private final Prompt prompt;
    private final JOSEObject requestObj;
    private final URL requestURI;
    private final JWT idTokenHint;
    private final String loginHint;

    public OIDCAuthorizationRequest(ResponseTypeSet rts, Scope scope, ClientID clientID, URL redirectURI, Nonce nonce) {
        this(rts, scope, clientID, redirectURI, nonce, null, null, null, null, null);
    }

    public OIDCAuthorizationRequest(ResponseTypeSet rts, Scope scope, ClientID clientID, URL redirectURI, Nonce nonce, State state, Display display, Prompt prompt, JWT idTokenHint, String loginHint) {
        this(rts, scope, clientID, redirectURI, nonce, state, display, prompt, (JOSEObject)null, idTokenHint, loginHint);
    }

    public OIDCAuthorizationRequest(ResponseTypeSet rts, Scope scope, ClientID clientID, URL redirectURI, Nonce nonce, State state, Display display, Prompt prompt, JOSEObject requestObj, JWT idTokenHint, String loginHint) {
        super(rts, clientID, redirectURI, scope, state);
        if (redirectURI == null) {
            throw new IllegalArgumentException("The redirect URI must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("The scope must not be null");
        }
        if (!scope.contains(OIDCScopeToken.OPENID)) {
            throw new IllegalArgumentException("The scope must include an \"openid\" token");
        }
        if (rts.impliesImplicitFlow() && nonce == null) {
            throw new IllegalArgumentException("Nonce is required in implicit protocol flow");
        }
        this.nonce = nonce;
        this.display = display;
        this.prompt = prompt;
        this.requestObj = requestObj;
        this.requestURI = null;
        this.idTokenHint = idTokenHint;
        this.loginHint = loginHint;
    }

    public OIDCAuthorizationRequest(ResponseTypeSet rts, Scope scope, ClientID clientID, URL redirectURI, Nonce nonce, State state, Display display, Prompt prompt, URL requestURI, JWT idTokenHint, String loginHint) {
        super(rts, clientID, redirectURI, scope, state);
        if (redirectURI == null) {
            throw new IllegalArgumentException("The redirect URI must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("The scope must not be null");
        }
        if (!scope.contains(OIDCScopeToken.OPENID)) {
            throw new IllegalArgumentException("The scope must include an \"openid\" token");
        }
        if (rts.impliesImplicitFlow() && nonce == null) {
            throw new IllegalArgumentException("Nonce is required in implicit protocol flow");
        }
        this.nonce = nonce;
        this.display = display;
        this.prompt = prompt;
        this.requestObj = null;
        this.requestURI = requestURI;
        this.idTokenHint = idTokenHint;
        this.loginHint = loginHint;
    }

    public Nonce getNonce() {
        return this.nonce;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public JOSEObject getRequestObject() {
        return this.requestObj;
    }

    public URL getRequestObjectURI() {
        return this.requestURI;
    }

    public boolean hasRequestObject() {
        return this.requestObj != null || this.requestURI != null;
    }

    public JWT getIDTokenHint() {
        return this.idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    @Override
    public Map<String, String> toParameters() throws SerializeException {
        Map<String, String> params = super.toParameters();
        if (this.nonce != null) {
            params.put("nonce", this.nonce.toString());
        }
        if (this.display != null) {
            params.put("display", this.display.toString());
        }
        if (this.prompt != null) {
            params.put("prompt", this.prompt.toString());
        }
        if (this.requestObj != null) {
            try {
                params.put("request", this.requestObj.serialize());
            }
            catch (IllegalStateException e) {
                throw new SerializeException("Couldn't serialize request object: " + e.getMessage(), e);
            }
        }
        if (this.requestURI != null) {
            params.put("request_uri", this.requestURI.toString());
        }
        if (this.idTokenHint != null) {
            try {
                params.put("id_token_hint", this.idTokenHint.serialize());
            }
            catch (IllegalStateException e) {
                throw new SerializeException("Couldn't serialize ID token hint: " + e.getMessage(), e);
            }
        }
        if (this.loginHint != null) {
            params.put("login_hint", this.loginHint);
        }
        return params;
    }

    public static OIDCAuthorizationRequest parse(Map<String, String> params) throws ParseException {
        AuthorizationRequest ar = AuthorizationRequest.parse(params);
        URL redirectURI = ar.getRedirectURI();
        if (redirectURI == null) {
            throw new ParseException("Missing \"redirect_uri\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        State state = ar.getState();
        ResponseTypeSet rts = ar.getResponseTypeSet();
        for (ResponseType rt : rts) {
            if (rt.equals(ResponseType.CODE) || rt.equals(ResponseType.TOKEN) || rt.equals(OIDCResponseType.ID_TOKEN)) continue;
            throw new ParseException("Unsupported \"response_type\" parameter: " + rt, OAuth2Error.UNSUPPORTED_RESPONSE_TYPE, redirectURI, state, null);
        }
        Scope scope = ar.getScope();
        if (scope == null) {
            throw new ParseException("Missing \"scope\" parameter", OAuth2Error.INVALID_REQUEST, redirectURI, state, null);
        }
        if (!scope.contains(OIDCScopeToken.OPENID)) {
            throw new ParseException("The scope must include an \"openid\" token", OAuth2Error.INVALID_REQUEST, redirectURI, state, null);
        }
        ClientID clientID = ar.getClientID();
        Nonce nonce = Nonce.parse(params.get("nonce"));
        if (rts.impliesImplicitFlow() && nonce == null) {
            throw new ParseException("Missing \"nonce\" parameter", OAuth2Error.INVALID_REQUEST, redirectURI, state, null);
        }
        Display display = null;
        try {
            display = Display.parse(params.get("display"));
        }
        catch (ParseException e) {
            throw new ParseException("Invalid \"display\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, redirectURI, state, e);
        }
        Prompt prompt = null;
        try {
            prompt = Prompt.parse(params.get("prompt"));
        }
        catch (ParseException e) {
            throw new ParseException("Invalid \"prompt\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, redirectURI, state, e);
        }
        String v = params.get("request");
        JOSEObject requestObj = null;
        if (StringUtils.isDefined(v)) {
            try {
                requestObj = JOSEObject.parse((String)v);
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid \"request\" parameter: " + e.getMessage(), OIDCError.INVALID_OPENID_REQUEST_OBJECT, redirectURI, state, e);
            }
        }
        v = params.get("request_uri");
        URL requestURI = null;
        if (StringUtils.isDefined(v)) {
            if (requestObj != null) {
                throw new ParseException("Invalid request: Found mutually exclusive \"request_object\" and \"request_uri\" parameters", OAuth2Error.INVALID_REQUEST, redirectURI, state, null);
            }
            try {
                requestURI = new URL(v);
            }
            catch (MalformedURLException e) {
                throw new ParseException("Invalid \"redirect_uri\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, redirectURI, state, e);
            }
        }
        v = params.get("id_token_hint");
        JWT idTokenHint = null;
        if (StringUtils.isDefined(v)) {
            try {
                idTokenHint = JWTParser.parse((String)v);
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid \"id_token_hint\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, redirectURI, state, e);
            }
        }
        String loginHint = params.get("login_hint");
        if (requestObj != null) {
            return new OIDCAuthorizationRequest(rts, scope, clientID, redirectURI, nonce, state, display, prompt, requestObj, idTokenHint, loginHint);
        }
        if (requestURI != null) {
            return new OIDCAuthorizationRequest(rts, scope, clientID, redirectURI, nonce, state, display, prompt, requestURI, idTokenHint, loginHint);
        }
        return new OIDCAuthorizationRequest(rts, scope, clientID, redirectURI, nonce, state, display, prompt, idTokenHint, loginHint);
    }

    public static OIDCAuthorizationRequest parse(String query) throws ParseException {
        return OIDCAuthorizationRequest.parse(URLUtils.parseParameters(query));
    }

    public static AuthorizationRequest parse(HTTPRequest httpRequest) throws ParseException {
        String query = httpRequest.getQuery();
        if (query == null) {
            throw new ParseException("Missing URL query string");
        }
        return OIDCAuthorizationRequest.parse(query);
    }
}

