/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.ResponseTypeSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.Display;
import com.nimbusds.openid.connect.sdk.IDTokenClaimsRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCAuthorizationRequest;
import com.nimbusds.openid.connect.sdk.OIDCError;
import com.nimbusds.openid.connect.sdk.OIDCResponseType;
import com.nimbusds.openid.connect.sdk.OIDCScopeToken;
import com.nimbusds.openid.connect.sdk.Prompt;
import com.nimbusds.openid.connect.sdk.ResolveException;
import com.nimbusds.openid.connect.sdk.ResolvedOIDCAuthorizationRequest;
import com.nimbusds.openid.connect.sdk.UserInfoClaimsRequest;
import com.nimbusds.openid.connect.sdk.util.DefaultJOSEObjectRetriever;
import com.nimbusds.openid.connect.sdk.util.JOSEObjectDecoder;
import com.nimbusds.openid.connect.sdk.util.JOSEObjectRetriever;
import java.io.IOException;
import java.net.URL;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;

@ThreadSafe
public class OIDCAuthorizationRequestResolver {
    private final JOSEObjectRetriever retriever;
    private final JOSEObjectDecoder decoder;

    public OIDCAuthorizationRequestResolver(JOSEObjectDecoder decoder) {
        this(new DefaultJOSEObjectRetriever(), decoder);
    }

    public OIDCAuthorizationRequestResolver(JOSEObjectRetriever retriever, JOSEObjectDecoder decoder) {
        this.retriever = retriever;
        this.decoder = decoder;
    }

    public JOSEObjectRetriever getJOSEObjectRetriever() {
        return this.retriever;
    }

    public JOSEObjectDecoder getJOSEObjectDecoder() {
        return this.decoder;
    }

    private JOSEObject downloadRequestObject(URL url) throws ResolveException {
        try {
            return this.retriever.downloadJOSEObject(url);
        }
        catch (IOException e) {
            throw new ResolveException("Couldn't download OpenID request object: " + e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ResolveException("Couldn't parse downloaded OpenID request object: " + e.getMessage(), e);
        }
    }

    private JSONObject decodeRequestObject(JOSEObject joseObject) throws ResolveException {
        Payload payload = null;
        try {
            payload = this.decoder.decodeJOSEObject(joseObject);
        }
        catch (JOSEException e) {
            throw new ResolveException("Couldn't decode/verify JOSE encoded OpenID request object: " + e.getMessage(), e);
        }
        JSONObject jsonObject = payload.toJSONObject();
        if (jsonObject == null) {
            throw new ResolveException("JOSE object payload not a valid JSON object");
        }
        return jsonObject;
    }

    private static ResponseTypeSet resolveResponseTypeSet(OIDCAuthorizationRequest request, JSONObject requestObject) throws ResolveException {
        ResponseTypeSet rts = request.getResponseTypeSet();
        if (JSONObjectUtils.containsKey(requestObject, "response_type")) {
            ResponseTypeSet rtsCopy = null;
            try {
                String value = JSONObjectUtils.getString(requestObject, "response_type");
                rtsCopy = ResponseTypeSet.parse(value);
            }
            catch (ParseException e) {
                throw new ResolveException("Invalid \"response_type\" parameter in OpenID request object: " + e.getMessage(), e);
            }
            if (!rts.containsAll(rtsCopy)) {
                throw new ResolveException("Mismatched \"response_type\" parameter in OpenID request object");
            }
        }
        return rts;
    }

    private static Scope resolveScope(OIDCAuthorizationRequest request, JSONObject requestObject) throws ResolveException {
        Scope scope = request.getScope();
        if (JSONObjectUtils.containsKey(requestObject, "scope")) {
            Scope scopeCopy = null;
            try {
                String value = JSONObjectUtils.getString(requestObject, "scope");
                scopeCopy = Scope.parse(value);
            }
            catch (ParseException e) {
                throw new ResolveException("Invalid \"scope\" parameter in OpenID request object: " + e.getMessage(), e);
            }
            if (!scope.containsAll(scopeCopy)) {
                throw new ResolveException("Mismatched \"scope\" parameter in OpenID request object");
            }
            if (!scope.contains(OIDCScopeToken.OPENID)) {
                throw new ResolveException("The scope must include an \"openid\" token");
            }
        }
        return scope;
    }

    private static ClientID resolveClientID(OIDCAuthorizationRequest request, JSONObject requestObject) throws ResolveException {
        ClientID clientID = request.getClientID();
        if (JSONObjectUtils.containsKey(requestObject, "client_id")) {
            ClientID clientIDCopy = null;
            try {
                clientIDCopy = new ClientID(JSONObjectUtils.getString(requestObject, "client_id"));
            }
            catch (ParseException e) {
                throw new ResolveException("Invalid \"client_id\" parameter in OpenID request object: " + e.getMessage(), e);
            }
            if (!clientID.equals(clientIDCopy)) {
                throw new ResolveException("Mismatched \"client_id\" parameter in OpenID request object");
            }
        }
        return clientID;
    }

    private static URL resolveRedirectURI(OIDCAuthorizationRequest request, JSONObject requestObject) throws ResolveException {
        URL url = request.getRedirectURI();
        if (JSONObjectUtils.containsKey(requestObject, "redirect_uri")) {
            URL urlCopy = null;
            try {
                urlCopy = JSONObjectUtils.getURL(requestObject, "redirect_uri");
            }
            catch (ParseException e) {
                throw new ResolveException("Invalid \"redirect_uri\" parameter in OpenID request object: " + e.getMessage(), e);
            }
            if (!url.equals(urlCopy)) {
                throw new ResolveException("Mismatched \"redirect_uri\" parameter in OpenID request object");
            }
        }
        return url;
    }

    private static Nonce resolveNonce(OIDCAuthorizationRequest request, JSONObject requestObject) throws ResolveException {
        Nonce nonce = request.getNonce();
        if (JSONObjectUtils.containsKey(requestObject, "nonce")) {
            Nonce nonceCopy = null;
            try {
                nonceCopy = new Nonce(JSONObjectUtils.getString(requestObject, "nonce"));
            }
            catch (ParseException e) {
                throw new ResolveException("Invalid \"nonce\" parameter in OpenID request object: " + e.getMessage(), e);
            }
            if (nonce == null) {
                nonce = nonceCopy;
            } else if (!nonce.equals(nonceCopy)) {
                throw new ResolveException("Mismatched \"nonce\" parameter in OpenID request object");
            }
        }
        return nonce;
    }

    private static State resolveState(OIDCAuthorizationRequest request, JSONObject requestObject) throws ResolveException {
        State state = request.getState();
        if (JSONObjectUtils.containsKey(requestObject, "state")) {
            State stateCopy = null;
            try {
                stateCopy = new State(JSONObjectUtils.getString(requestObject, "state"));
            }
            catch (ParseException e) {
                throw new ResolveException("Invalid \"state\" parameter in OpenID request object: " + e.getMessage(), e);
            }
            if (state == null) {
                state = stateCopy;
            } else if (!state.equals(stateCopy)) {
                throw new ResolveException("Mismatched \"state\" parameter in OpenID request object");
            }
        }
        return state;
    }

    private static Display resolveDisplay(OIDCAuthorizationRequest request, JSONObject requestObject) throws ResolveException {
        Display display = request.getDisplay();
        if (JSONObjectUtils.containsKey(requestObject, "display")) {
            Display displayCopy = null;
            try {
                displayCopy = Display.parse(JSONObjectUtils.getString(requestObject, "display"));
            }
            catch (ParseException e) {
                throw new ResolveException("Invalid \"display\" parameter in OpenID request object: " + e.getMessage(), e);
            }
            if (display == null) {
                display = displayCopy;
            } else if (!display.equals((Object)displayCopy)) {
                throw new ResolveException("Mismatched \"display\" parameter in OpenID request object");
            }
        }
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private static Prompt resolvePrompt(OIDCAuthorizationRequest request, JSONObject requestObject) throws ResolveException {
        Prompt prompt = request.getPrompt();
        if (JSONObjectUtils.containsKey(requestObject, "prompt")) {
            Prompt promptCopy = null;
            try {
                promptCopy = Prompt.parse(JSONObjectUtils.getString(requestObject, "prompt"));
            }
            catch (ParseException e) {
                throw new ResolveException("Invalid \"prompt\" parameter in OpenID request object: " + e.getMessage(), e);
            }
            if (prompt == null) {
                prompt = promptCopy;
            } else if (!prompt.equals(promptCopy)) {
                throw new ResolveException("Mismatched \"prompt\" parameter in OpenID request object");
            }
        }
        return prompt;
    }

    private static JWT resolveIDTokenHint(OIDCAuthorizationRequest request, JSONObject requestObject) throws ResolveException {
        JWT idTokenHint = request.getIDTokenHint();
        if (JSONObjectUtils.containsKey(requestObject, "id_token_hint")) {
            JWT idTokenHintCopy = null;
            try {
                idTokenHintCopy = JWTParser.parse((String)JSONObjectUtils.getString(requestObject, "id_token_hint"));
            }
            catch (ParseException e) {
                throw new ResolveException("Invalid \"id_token_hint\" parameter in OpenID request object: " + e.getMessage(), e);
            }
            catch (java.text.ParseException e) {
                throw new ResolveException("Invalid \"id_token_hint\" parameter in OpenID request object: " + e.getMessage(), e);
            }
            if (idTokenHint == null) {
                idTokenHint = idTokenHintCopy;
            } else if (!idTokenHint.equals(idTokenHintCopy)) {
                throw new ResolveException("Mismatched \"id_token_hint\" parameter in OpenID request object");
            }
        }
        return idTokenHint;
    }

    private static String resolveLoginHint(OIDCAuthorizationRequest request, JSONObject requestObject) throws ResolveException {
        String loginHint = request.getLoginHint();
        if (JSONObjectUtils.containsKey(requestObject, "login_hint")) {
            String loginHintCopy = null;
            try {
                loginHintCopy = JSONObjectUtils.getString(requestObject, "login_hint");
            }
            catch (ParseException e) {
                throw new ResolveException("Invalid \"login_hint\" parameter in OpenID request object: " + e.getMessage(), e);
            }
            if (loginHint == null) {
                loginHint = loginHintCopy;
            } else if (!loginHint.equals(loginHintCopy)) {
                throw new ResolveException("Mismatched \"login_hint\" parameter in OpenID request object");
            }
        }
        return loginHint;
    }

    private static IDTokenClaimsRequest resolveIDTokenClaimsRequest(ResponseTypeSet rts, JSONObject requestObject, URL redirectURI, State state) throws ResolveException {
        if (!rts.contains(ResponseType.CODE) && !rts.contains(OIDCResponseType.ID_TOKEN)) {
            return null;
        }
        JSONObject idTokenObject = null;
        if (JSONObjectUtils.containsKey(requestObject, "id_token")) {
            try {
                idTokenObject = JSONObjectUtils.getJSONObject(requestObject, "id_token");
            }
            catch (ParseException e) {
                throw new ResolveException("Invalid \"id_token\" member in OpenID request object: " + e.getMessage(), e);
            }
        }
        return new IDTokenClaimsRequest(rts, idTokenObject, redirectURI, state);
    }

    private static UserInfoClaimsRequest resolveUserInfoClaimsRequest(ResponseTypeSet rts, Scope scope, JSONObject requestObject) throws ResolveException {
        if (!rts.contains(ResponseType.CODE) && !rts.contains(ResponseType.TOKEN)) {
            return null;
        }
        JSONObject userInfoObject = null;
        if (JSONObjectUtils.containsKey(requestObject, "userinfo")) {
            try {
                userInfoObject = JSONObjectUtils.getJSONObject(requestObject, "userinfo");
            }
            catch (ParseException e) {
                throw new ResolveException("Invalid \"userinfo\" member in OpenID request object: " + e.getMessage(), e);
            }
        }
        return new UserInfoClaimsRequest(scope, userInfoObject);
    }

    public ResolvedOIDCAuthorizationRequest resolve(OIDCAuthorizationRequest request) throws ResolveException {
        String loginHint;
        URL redirectURI = request.getRedirectURI();
        State state = request.getState();
        JSONObject requestObject = null;
        if (request.hasRequestObject()) {
            JOSEObject encodedRequestObject = null;
            if (request.getRequestObjectURI() != null) {
                try {
                    encodedRequestObject = this.downloadRequestObject(request.getRequestObjectURI());
                }
                catch (ResolveException e) {
                    throw new ResolveException(e.getMessage(), OIDCError.INVALID_REQUEST_URI, redirectURI, state, e);
                }
            } else {
                encodedRequestObject = request.getRequestObject();
            }
            try {
                requestObject = this.decodeRequestObject(encodedRequestObject);
            }
            catch (ResolveException e) {
                throw new ResolveException(e.getMessage(), OIDCError.INVALID_OPENID_REQUEST_OBJECT, redirectURI, state, e);
            }
        }
        ResponseTypeSet rts = null;
        Scope scope = null;
        ClientID clientID = null;
        Nonce nonce = null;
        Display display = null;
        Prompt prompt = null;
        JWT idTokenHint = null;
        IDTokenClaimsRequest idTokenClaimsRequest = null;
        UserInfoClaimsRequest userInfoClaimsRequest = null;
        try {
            redirectURI = OIDCAuthorizationRequestResolver.resolveRedirectURI(request, requestObject);
            state = OIDCAuthorizationRequestResolver.resolveState(request, requestObject);
            rts = OIDCAuthorizationRequestResolver.resolveResponseTypeSet(request, requestObject);
            scope = OIDCAuthorizationRequestResolver.resolveScope(request, requestObject);
            clientID = OIDCAuthorizationRequestResolver.resolveClientID(request, requestObject);
            nonce = OIDCAuthorizationRequestResolver.resolveNonce(request, requestObject);
            display = OIDCAuthorizationRequestResolver.resolveDisplay(request, requestObject);
            prompt = OIDCAuthorizationRequestResolver.resolvePrompt(request, requestObject);
            idTokenHint = OIDCAuthorizationRequestResolver.resolveIDTokenHint(request, requestObject);
            loginHint = OIDCAuthorizationRequestResolver.resolveLoginHint(request, requestObject);
            idTokenClaimsRequest = OIDCAuthorizationRequestResolver.resolveIDTokenClaimsRequest(rts, requestObject, redirectURI, state);
            userInfoClaimsRequest = OIDCAuthorizationRequestResolver.resolveUserInfoClaimsRequest(rts, scope, requestObject);
        }
        catch (ResolveException e) {
            throw new ResolveException(e.getMessage(), OAuth2Error.INVALID_REQUEST, redirectURI, state, e);
        }
        return new ResolvedOIDCAuthorizationRequest(rts, clientID, redirectURI, nonce, state, display, prompt, idTokenHint, loginHint, idTokenClaimsRequest, userInfoClaimsRequest);
    }
}

