/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationSuccessResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.ResponseTypeSet;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.OIDCAuthorizationResponse;
import com.nimbusds.openid.connect.sdk.OIDCResponseType;
import java.net.URL;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class OIDCAuthorizationSuccessResponse
extends AuthorizationSuccessResponse
implements OIDCAuthorizationResponse {
    private final JWT idToken;

    public OIDCAuthorizationSuccessResponse(URL redirectURI, AuthorizationCode code, JWT idToken, AccessToken accessToken, State state) {
        super(redirectURI, code, accessToken, state);
        this.idToken = idToken;
    }

    @Override
    public ResponseTypeSet getImpliedResponseTypeSet() {
        ResponseTypeSet rts = new ResponseTypeSet();
        if (this.getAuthorizationCode() != null) {
            rts.add(ResponseType.CODE);
        }
        if (this.getIDToken() != null) {
            rts.add(OIDCResponseType.ID_TOKEN);
        }
        if (this.getAccessToken() != null) {
            rts.add(ResponseType.TOKEN);
        }
        return rts;
    }

    public JWT getIDToken() {
        return this.idToken;
    }

    @Override
    public Map<String, String> toParameters() throws SerializeException {
        Map<String, String> params = super.toParameters();
        if (this.idToken != null) {
            try {
                params.put("id_token", this.idToken.serialize());
            }
            catch (IllegalStateException e) {
                throw new SerializeException("Couldn't serialize ID token: " + e.getMessage(), e);
            }
        }
        return params;
    }

    public static OIDCAuthorizationSuccessResponse parse(URL redirectURI, Map<String, String> params) throws ParseException {
        AuthorizationSuccessResponse asr = AuthorizationSuccessResponse.parse(redirectURI, params);
        JWT idToken = null;
        if (params.get("id_token") != null) {
            try {
                idToken = JWTParser.parse((String)params.get("id_token"));
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid ID Token JWT: " + e.getMessage(), e);
            }
        }
        return new OIDCAuthorizationSuccessResponse(redirectURI, asr.getAuthorizationCode(), idToken, asr.getAccessToken(), asr.getState());
    }

    public static OIDCAuthorizationSuccessResponse parse(URL uri) throws ParseException {
        String paramString = null;
        if (uri.getQuery() != null) {
            paramString = uri.getQuery();
        } else if (uri.getRef() != null) {
            paramString = uri.getRef();
        } else {
            throw new ParseException("Missing authorization response parameters");
        }
        Map<String, String> params = URLUtils.parseParameters(paramString);
        if (params == null) {
            throw new ParseException("Missing or invalid authorization response parameters");
        }
        return OIDCAuthorizationSuccessResponse.parse(URLUtils.getBaseURL(uri), params);
    }

    public static OIDCAuthorizationSuccessResponse parse(HTTPResponse httpResponse) throws ParseException {
        if (httpResponse.getStatusCode() != 302) {
            throw new ParseException("Unexpected HTTP status code, must be 302 (Found): " + httpResponse.getStatusCode());
        }
        URL location = httpResponse.getLocation();
        if (location == null) {
            throw new ParseException("Missing redirect URL / HTTP Location header");
        }
        return OIDCAuthorizationSuccessResponse.parse(location);
    }
}

