/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.openid.connect.sdk.OIDCClientRegistrationRequest;
import com.nimbusds.openid.connect.sdk.rp.Client;
import java.net.URL;
import net.minidev.json.JSONObject;

public class OIDCClientAddRequest
extends OIDCClientRegistrationRequest {
    private final Client client;

    public OIDCClientAddRequest(Client client) {
        if (client.getRedirectURIs() == null || client.getRedirectURIs().isEmpty()) {
            throw new IllegalArgumentException("The client details must specify one or more redirect URIs");
        }
        this.client = client;
    }

    public Client getClientDetails() {
        return this.client;
    }

    @Override
    public HTTPRequest toHTTPRequest(URL url) {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, url);
        if (this.getAccessToken() != null) {
            httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        }
        httpRequest.setContentType(CommonContentTypes.APPLICATION_JSON);
        httpRequest.setQuery(this.client.toJSONObject().toString());
        return httpRequest;
    }

    public static OIDCClientAddRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        JSONObject jsonObject = httpRequest.getQueryAsJSONObject();
        Client client = Client.parse(jsonObject);
        if (client.getRedirectURIs() == null || client.getRedirectURIs().isEmpty()) {
            throw new ParseException("The client details must specify one or more redirect URIs");
        }
        OIDCClientAddRequest req = new OIDCClientAddRequest(client);
        String authzHeaderValue = httpRequest.getAuthorization();
        if (StringUtils.isDefined(authzHeaderValue)) {
            req.setAccessToken(BearerAccessToken.parse(authzHeaderValue));
        }
        return req;
    }
}

