/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SuccessResponse;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.openid.connect.sdk.OIDCClientRegistrationResponse;
import com.nimbusds.openid.connect.sdk.rp.Client;
import net.jcip.annotations.Immutable;

@Immutable
public class OIDCClientDetailsResponse
extends OIDCClientRegistrationResponse
implements SuccessResponse {
    private Client client;

    public OIDCClientDetailsResponse(Client client) {
        if (client == null) {
            throw new IllegalArgumentException("The client details must not be null");
        }
        this.client = client;
    }

    public Client getClientDetails() {
        return this.client;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setContentType(CommonContentTypes.APPLICATION_JSON);
        httpResponse.setContent(this.client.toJSONObject().toString());
        return httpResponse;
    }

    public static OIDCClientDetailsResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        Client client = Client.parse(httpResponse.getContentAsJSONObject());
        return new OIDCClientDetailsResponse(client);
    }
}

