/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.OIDCClientRegistrationRequest;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class OIDCClientReadRequest
extends OIDCClientRegistrationRequest {
    private final ClientID clientID;

    public OIDCClientReadRequest(ClientID clientID) {
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.clientID = clientID;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    @Override
    public HTTPRequest toHTTPRequest(URL url) {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.GET, url);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.clientID.getValue());
        httpRequest.setQuery(URLUtils.serializeParameters(params));
        return httpRequest;
    }

    public static OIDCClientReadRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.GET);
        Map<String, String> params = httpRequest.getQueryParameters();
        String clientIDString = params.get("client_id");
        if (clientIDString == null) {
            throw new ParseException("Missing client_id");
        }
        OIDCClientReadRequest req = new OIDCClientReadRequest(new ClientID(clientIDString));
        String authzHeaderValue = httpRequest.getAuthorization();
        if (StringUtils.isDefined(authzHeaderValue)) {
            req.setAccessToken(BearerAccessToken.parse(authzHeaderValue));
        }
        return req;
    }
}

