/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ScopeToken;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minidev.json.JSONObject;

public class OIDCScopeToken
extends ScopeToken {
    public static final OIDCScopeToken OPENID = new OIDCScopeToken("openid", ScopeToken.Requirement.REQUIRED, new String[]{"sub"});
    public static final OIDCScopeToken PROFILE = new OIDCScopeToken("profile", new String[]{"name", "family_name", "given_name", "middle_name", "nickname", "preferred_username", "profile", "picture", "website", "gender", "birthdate", "zoneinfo", "locale", "updated_time"});
    public static final OIDCScopeToken EMAIL = new OIDCScopeToken("email", new String[]{"email", "email_verified"});
    public static final OIDCScopeToken ADDRESS = new OIDCScopeToken("address", new String[]{"formatted", "street_address", "locality", "region", "postal_code", "country"});
    public static final OIDCScopeToken PHONE = new OIDCScopeToken("phone", new String[]{"phone_number"});
    public static final OIDCScopeToken OFFLINE_ACCESS = new OIDCScopeToken("offline_access", null);
    private final Set<String> claims;

    private OIDCScopeToken(String value, ScopeToken.Requirement requirement, String[] claims) {
        super(value, requirement);
        this.claims = claims != null ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(claims))) : null;
    }

    private OIDCScopeToken(String value, String[] claims) {
        this(value, ScopeToken.Requirement.OPTIONAL, claims);
    }

    public Set<String> getClaims() {
        return this.claims;
    }

    public JSONObject getClaimsRequestJSONObject() {
        JSONObject req = new JSONObject();
        for (String claim : this.claims) {
            if (this.getRequirement() == ScopeToken.Requirement.REQUIRED) {
                JSONObject details = new JSONObject();
                details.put((Object)"essential", (Object)true);
                req.put((Object)claim, (Object)details);
                continue;
            }
            req.put((Object)claim, null);
        }
        return req;
    }
}

