/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import java.util.HashSet;
import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class Prompt
extends HashSet<Type> {
    public boolean isValid() {
        return this.size() <= 1 || !this.contains((Object)Type.NONE);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator it = super.iterator();
        while (it.hasNext()) {
            sb.append(((Type)((Object)it.next())).toString());
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static Prompt parse(String s) throws ParseException {
        String[] tokens;
        if (StringUtils.isUndefined(s)) {
            return null;
        }
        Prompt prompt = new Prompt();
        for (String t : tokens = s.split("\\s+")) {
            prompt.add(Type.parse(t));
        }
        if (!prompt.isValid()) {
            throw new ParseException("Invalid prompt set: " + s);
        }
        return prompt;
    }

    public static enum Type {
        NONE,
        LOGIN,
        CONSENT,
        SELECT_ACCOUNT;


        public String toString() {
            return super.toString().toLowerCase();
        }

        public static Type parse(String s) throws ParseException {
            if (s == null || s.trim().isEmpty()) {
                throw new ParseException("Null or empty prompt type string");
            }
            if (s.equals("none")) {
                return NONE;
            }
            if (s.equals("login")) {
                return LOGIN;
            }
            if (s.equals("consent")) {
                return CONSENT;
            }
            if (s.equals("select_account")) {
                return SELECT_ACCOUNT;
            }
            throw new ParseException("Unknown prompt type: " + s);
        }
    }
}

