/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.ResponseTypeSet;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.Display;
import com.nimbusds.openid.connect.sdk.IDTokenClaimsRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.Prompt;
import com.nimbusds.openid.connect.sdk.UserInfoClaimsRequest;
import java.net.URL;
import net.jcip.annotations.Immutable;

@Immutable
public final class ResolvedOIDCAuthorizationRequest {
    private final ResponseTypeSet rts;
    private final ClientID clientID;
    private final URL redirectURI;
    private final Nonce nonce;
    private final State state;
    private final Display display;
    private final Prompt prompt;
    private final JWT idTokenHint;
    private final String loginHint;
    private final IDTokenClaimsRequest idTokenClaimsRequest;
    private final UserInfoClaimsRequest userInfoClaimsRequest;

    public ResolvedOIDCAuthorizationRequest(ResponseTypeSet rts, ClientID clientID, URL redirectURI, Nonce nonce, State state, Display display, Prompt prompt, JWT idTokenHint, String loginHint, IDTokenClaimsRequest idTokenClaims, UserInfoClaimsRequest userInfoClaims) {
        if (rts == null) {
            throw new IllegalArgumentException("The response type set must not be null");
        }
        this.rts = rts;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.clientID = clientID;
        if (redirectURI == null) {
            throw new IllegalArgumentException("The redirect URI must not be null");
        }
        this.redirectURI = redirectURI;
        this.nonce = nonce;
        this.state = state;
        if (display == null) {
            throw new IllegalArgumentException("The display must not be null");
        }
        this.display = display;
        this.prompt = prompt;
        this.idTokenHint = idTokenHint;
        this.loginHint = loginHint;
        this.idTokenClaimsRequest = idTokenClaims;
        this.userInfoClaimsRequest = userInfoClaims;
    }

    public ResponseTypeSet getResponseTypeSet() {
        return this.rts;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public URL getRedirectURI() {
        return this.redirectURI;
    }

    public Nonce getNonce() {
        return this.nonce;
    }

    public State getState() {
        return this.state;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public JWT getIDTokenHint() {
        return this.idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public IDTokenClaimsRequest getIDTokenClaimsRequest() {
        return this.idTokenClaimsRequest;
    }

    public UserInfoClaimsRequest getUserInfoClaimsRequest() {
        return this.userInfoClaimsRequest;
    }
}

