/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import com.nimbusds.openid.connect.sdk.OIDCScopeToken;
import com.nimbusds.openid.connect.sdk.ResolveException;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class UserInfoClaimsRequest
extends ClaimsRequest {
    private LangTag[] preferredLocales;

    public static JSONObject getClaimsObjectForScope(Scope scope) {
        JSONObject claims = new JSONObject();
        if (scope.contains(OIDCScopeToken.PROFILE)) {
            claims.putAll((Map)OIDCScopeToken.PROFILE.getClaimsRequestJSONObject());
        }
        if (scope.contains(OIDCScopeToken.EMAIL)) {
            claims.putAll((Map)OIDCScopeToken.EMAIL.getClaimsRequestJSONObject());
        }
        if (scope.contains(OIDCScopeToken.PHONE)) {
            claims.putAll((Map)OIDCScopeToken.PHONE.getClaimsRequestJSONObject());
        }
        if (scope.contains(OIDCScopeToken.ADDRESS)) {
            JSONObject address = new JSONObject();
            address.put((Object)"address", (Object)OIDCScopeToken.ADDRESS.getClaimsRequestJSONObject());
            claims.putAll((Map)address);
        }
        return claims;
    }

    private static LangTag[] parsePreferredLocales(JSONObject object) throws LangTagException {
        LangTag[] preferredLocales = null;
        if (!object.containsKey((Object)"preferred_locales") || !(object.get((Object)"preferred_locales") instanceof List)) {
            return null;
        }
        List locales = (List)object.get((Object)"preferred_locales");
        preferredLocales = new LangTag[locales.size()];
        for (int i = 0; i < locales.size(); ++i) {
            Object item = locales.get(i);
            if (!(item instanceof String)) {
                throw new LangTagException("Invalid language tag at position " + i);
            }
            preferredLocales[i] = LangTag.parse((String)((String)item));
        }
        return preferredLocales;
    }

    public UserInfoClaimsRequest(Scope scope, JSONObject userInfoObject) throws ResolveException {
        this.requiredClaims.addAll(OIDCScopeToken.OPENID.getClaims());
        this.requestedClaims.putAll((Map)UserInfoClaimsRequest.getClaimsObjectForScope(scope));
        if (userInfoObject != null) {
            if (userInfoObject.containsKey((Object)"claims") && userInfoObject.get((Object)"claims") instanceof JSONObject) {
                JSONObject additionalClaims = (JSONObject)userInfoObject.get((Object)"claims");
                this.requestedClaims.putAll((Map)additionalClaims);
            }
            try {
                this.preferredLocales = UserInfoClaimsRequest.parsePreferredLocales(userInfoObject);
            }
            catch (LangTagException e) {
                throw new ResolveException("Couldn't parse preferred locales: " + e.getMessage(), e);
            }
        }
    }

    public LangTag[] getPreferredLocales() {
        return this.preferredLocales;
    }
}

