/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import java.net.URL;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class UserInfoRequest
implements Request {
    private final HTTPRequest.Method httpMethod;
    private final AccessToken accessToken;

    public UserInfoRequest(AccessToken accessToken) {
        this(HTTPRequest.Method.GET, accessToken);
    }

    public UserInfoRequest(HTTPRequest.Method httpMethod, AccessToken accessToken) {
        if (httpMethod == null) {
            throw new IllegalArgumentException("The HTTP method must not be null");
        }
        this.httpMethod = httpMethod;
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
        this.accessToken = accessToken;
    }

    public HTTPRequest.Method getMethod() {
        return this.httpMethod;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    @Override
    public HTTPRequest toHTTPRequest(URL url) throws SerializeException {
        HTTPRequest httpRequest = new HTTPRequest(this.httpMethod, url);
        switch (this.httpMethod) {
            case GET: {
                httpRequest.setAuthorization(this.accessToken.toAuthorizationHeader());
                httpRequest.setQuery("schema=openid");
                break;
            }
            case POST: {
                httpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
                httpRequest.setQuery("schema=openid&access_token=" + this.accessToken.getValue());
                break;
            }
            default: {
                throw new SerializeException("Unexpected HTTP method: " + (Object)((Object)this.httpMethod));
            }
        }
        return httpRequest;
    }

    public static UserInfoRequest parse(HTTPRequest httpRequest) throws ParseException {
        HTTPRequest.Method httpMethod = httpRequest.getMethod();
        AccessToken accessToken = null;
        switch (httpMethod) {
            case GET: {
                String authzHeader = httpRequest.getAuthorization();
                if (authzHeader == null) {
                    throw new ParseException("Missing HTTP Authorization header");
                }
                accessToken = AccessToken.parse(authzHeader);
                String query = httpRequest.getQuery();
                if (query == null) {
                    throw new ParseException("Missing query string");
                }
                if (query.indexOf("schema=openid") >= 0) break;
                throw new ParseException("Missing or unexpected schema parameter, must be \"openid\"");
            }
            case POST: {
                httpRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
                Map<String, String> params = httpRequest.getQueryParameters();
                if (!params.containsKey("schema")) {
                    throw new ParseException("Missing schema parameter");
                }
                if ("openid".equals(params.get("schema"))) {
                    throw new ParseException("Unexpected schema parameter, must be \"openid\"");
                }
                if (!params.containsKey("access_token")) {
                    throw new ParseException("Missing access_token parameter");
                }
                accessToken = AccessToken.parse(params.get("access_token"));
                break;
            }
            default: {
                throw new ParseException("Unexpected HTTP method: " + (Object)((Object)httpMethod));
            }
        }
        return new UserInfoRequest(httpMethod, accessToken);
    }
}

