/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.op;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.ResponseTypeSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.ScopeToken;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.Display;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minidev.json.JSONObject;

public class ProviderConfiguration {
    public static final String VERSION = "3.0";
    private Issuer issuer;
    private URL authzEndpoint;
    private URL tokenEndpoint;
    private URL userInfoEndpoint;
    private URL regEndpoint;
    private URL jwkSetURL;
    private URL encryptionJWKSetURL;
    private URL x509URL;
    private URL encryptionX509URL;
    private Scope scope;
    private ResponseTypeSet rts;
    private Set<ACR> acrValues;
    private Set<SubjectType> subjectTypes;
    private Set<ClientAuthenticationMethod> tokenEndpointAuthMethods;
    private Set<JWSAlgorithm> tokenEndpointJWSAlgs;
    private Set<JWSAlgorithm> requestObjectJWSAlgs;
    private Set<JWEAlgorithm> requestObjectJWEAlgs;
    private Set<EncryptionMethod> requestObjectJWEEncs;
    private Set<JWSAlgorithm> idTokenJWSAlgs;
    private Set<JWEAlgorithm> idTokenJWEAlgs;
    private Set<EncryptionMethod> idTokenJWEEncs;
    private Set<JWSAlgorithm> userInfoJWSAlgs;
    private Set<JWEAlgorithm> userInfoJWEAlgs;
    private Set<EncryptionMethod> userInfoJWEEncs;
    private Set<Display> displays;
    private Set<String> claims;
    private URL serviceDocsURL;

    private ProviderConfiguration() {
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public URL getAuthorizationEndpointURL() {
        return this.authzEndpoint;
    }

    public URL getTokenEndpointURL() {
        return this.tokenEndpoint;
    }

    public URL getUserInfoEndpointURL() {
        return this.userInfoEndpoint;
    }

    public URL getRegistrationEndpointURL() {
        return this.regEndpoint;
    }

    public URL getJWKSetURL() {
        return this.jwkSetURL;
    }

    public URL getEncryptionJWKSetURL() {
        return this.encryptionJWKSetURL;
    }

    public URL getX509URL() {
        return this.x509URL;
    }

    public URL getEncryptionX509URL() {
        return this.encryptionX509URL;
    }

    public Scope getScope() {
        return this.scope;
    }

    public ResponseTypeSet getResponseTypeSet() {
        return this.rts;
    }

    public Set<ACR> getACRs() {
        return this.acrValues;
    }

    public Set<SubjectType> getSubjectTypes() {
        return this.subjectTypes;
    }

    public Set<ClientAuthenticationMethod> getTokenEndpointAuthMethods() {
        return this.tokenEndpointAuthMethods;
    }

    public Set<JWSAlgorithm> getTokenEndpointJWSAlgs() {
        return this.tokenEndpointJWSAlgs;
    }

    public Set<JWSAlgorithm> getRequestObjectJWSAlgs() {
        return this.requestObjectJWSAlgs;
    }

    public Set<JWEAlgorithm> getRequestObjectJWEAlgs() {
        return this.requestObjectJWEAlgs;
    }

    public Set<EncryptionMethod> getRequestObjectJWEEncs() {
        return this.requestObjectJWEEncs;
    }

    public Set<JWSAlgorithm> getIDTokenJWSAlgs() {
        return this.idTokenJWSAlgs;
    }

    public Set<JWEAlgorithm> getIDTokenJWEAlgs() {
        return this.idTokenJWEAlgs;
    }

    public Set<EncryptionMethod> getIDTokenJWEEncs() {
        return this.idTokenJWEEncs;
    }

    public Set<JWSAlgorithm> getUserInfoJWSAlgs() {
        return this.idTokenJWSAlgs;
    }

    public Set<JWEAlgorithm> getUserInfoJWEAlgs() {
        return this.idTokenJWEAlgs;
    }

    public Set<EncryptionMethod> getUserInfoJWEEncs() {
        return this.idTokenJWEEncs;
    }

    public Set<Display> getDisplays() {
        return this.displays;
    }

    public Set<String> getClaims() {
        return this.claims;
    }

    public URL getServiceDocsURL() {
        return this.serviceDocsURL;
    }

    public static ProviderConfiguration parse(JSONObject jsonObject) throws ParseException {
        String[] stringArray;
        String version = JSONObjectUtils.getString(jsonObject, "version");
        if (!version.equals(VERSION)) {
            throw new ParseException("The version must be \"3.0\"");
        }
        ProviderConfiguration config = new ProviderConfiguration();
        URL issuerURL = JSONObjectUtils.getURL(jsonObject, "issuer");
        config.issuer = new Issuer(issuerURL.toString());
        if (jsonObject.containsKey((Object)"authorization_endpoint")) {
            config.authzEndpoint = JSONObjectUtils.getURL(jsonObject, "authorization_endpoint");
        }
        if (jsonObject.containsKey((Object)"token_endpoint")) {
            config.tokenEndpoint = JSONObjectUtils.getURL(jsonObject, "token_endpoint");
        }
        if (jsonObject.containsKey((Object)"userinfo_endpoint")) {
            config.userInfoEndpoint = JSONObjectUtils.getURL(jsonObject, "userinfo_endpoint");
        }
        if (jsonObject.containsKey((Object)"registration_endpoint")) {
            config.regEndpoint = JSONObjectUtils.getURL(jsonObject, "registration_endpoint");
        }
        if (jsonObject.containsKey((Object)"jwk_url")) {
            config.jwkSetURL = JSONObjectUtils.getURL(jsonObject, "jwk_url");
        }
        if (jsonObject.containsKey((Object)"jwk_encryption_url")) {
            config.encryptionJWKSetURL = JSONObjectUtils.getURL(jsonObject, "jwk_encryption_url");
        }
        config.x509URL = JSONObjectUtils.getURL(jsonObject, "x509_url");
        if (jsonObject.containsKey((Object)"x509_encryption_url")) {
            config.encryptionX509URL = JSONObjectUtils.getURL(jsonObject, "x509_encryption_url");
        }
        if (jsonObject.containsKey((Object)"scopes_supported")) {
            if (jsonObject.get((Object)"scopes_supported") instanceof String) {
                config.scope = Scope.parse(JSONObjectUtils.getString(jsonObject, "scopes_supported"));
            } else {
                stringArray = JSONObjectUtils.getStringArray(jsonObject, "scopes_supported");
                config.scope = new Scope();
                for (String v : stringArray) {
                    if (v == null) continue;
                    config.scope.add(new ScopeToken(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"response_types_supported")) {
            if (jsonObject.get((Object)"response_types_supported") instanceof String) {
                config.rts = ResponseTypeSet.parse(JSONObjectUtils.getString(jsonObject, "response_types_supported"));
            } else {
                stringArray = JSONObjectUtils.getStringArray(jsonObject, "response_types_supported");
                config.rts = new ResponseTypeSet();
                for (String v : stringArray) {
                    if (v == null) continue;
                    config.rts.add(new ResponseType(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"acr_values_supported")) {
            config.acrValues = new LinkedHashSet<ACR>();
            if (jsonObject.get((Object)"acr_values_supported") instanceof String) {
                config.acrValues.add(new ACR(JSONObjectUtils.getString(jsonObject, "acr_values_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "acr_values_supported")) {
                    if (v == null) continue;
                    config.acrValues.add(new ACR(v));
                }
            }
        }
        config.subjectTypes = new LinkedHashSet<SubjectType>();
        if (jsonObject.get((Object)"subject_types_supported") instanceof String) {
            config.subjectTypes.add(SubjectType.parse(JSONObjectUtils.getString(jsonObject, "subject_types_supported")));
        } else {
            for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "subject_types_supported")) {
                config.subjectTypes.add(SubjectType.parse(v));
            }
        }
        if (jsonObject.containsKey((Object)"userinfo_signing_alg_values_supported")) {
            config.userInfoJWSAlgs = new LinkedHashSet<JWSAlgorithm>();
            if (jsonObject.get((Object)"userinfo_signing_alg_values_supported") instanceof String) {
                config.userInfoJWSAlgs.add(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "userinfo_signing_alg_values_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "userinfo_signing_alg_values_supported")) {
                    if (v == null) continue;
                    config.userInfoJWSAlgs.add(new JWSAlgorithm(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"userinfo_encryption_alg_values_supported")) {
            config.userInfoJWEAlgs = new LinkedHashSet<JWEAlgorithm>();
            if (jsonObject.get((Object)"userinfo_encryption_alg_values_supported") instanceof String) {
                config.userInfoJWEAlgs.add(new JWEAlgorithm(JSONObjectUtils.getString(jsonObject, "userinfo_encryption_alg_values_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "userinfo_encryption_alg_values_supported")) {
                    if (v == null) continue;
                    config.userInfoJWEAlgs.add(new JWEAlgorithm(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"userinfo_encryption_enc_values_supported")) {
            config.userInfoJWEEncs = new LinkedHashSet<EncryptionMethod>();
            if (jsonObject.get((Object)"userinfo_encryption_enc_values_supported") instanceof String) {
                config.userInfoJWEEncs.add(new EncryptionMethod(JSONObjectUtils.getString(jsonObject, "userinfo_encryption_enc_values_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "userinfo_encryption_enc_values_supported")) {
                    if (v == null) continue;
                    config.userInfoJWEEncs.add(new EncryptionMethod(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"id_token_signing_alg_values_supported")) {
            config.idTokenJWSAlgs = new LinkedHashSet<JWSAlgorithm>();
            if (jsonObject.get((Object)"id_token_signing_alg_values_supported") instanceof String) {
                config.idTokenJWSAlgs.add(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "id_token_signing_alg_values_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "id_token_signing_alg_values_supported")) {
                    if (v == null) continue;
                    config.idTokenJWSAlgs.add(new JWSAlgorithm(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"id_token_encryption_alg_values_supported")) {
            config.idTokenJWEAlgs = new LinkedHashSet<JWEAlgorithm>();
            if (jsonObject.get((Object)"id_token_encryption_alg_values_supported") instanceof String) {
                config.idTokenJWEAlgs.add(new JWEAlgorithm(JSONObjectUtils.getString(jsonObject, "id_token_encryption_alg_values_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "id_token_encryption_alg_values_supported")) {
                    if (v == null) continue;
                    config.idTokenJWEAlgs.add(new JWEAlgorithm(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"id_token_encryption_enc_values_supported")) {
            config.idTokenJWEEncs = new LinkedHashSet<EncryptionMethod>();
            if (jsonObject.get((Object)"id_token_encryption_enc_values_supported") instanceof String) {
                config.idTokenJWEEncs.add(new EncryptionMethod(JSONObjectUtils.getString(jsonObject, "id_token_encryption_enc_values_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "id_token_encryption_enc_values_supported")) {
                    if (v == null) continue;
                    config.idTokenJWEEncs.add(new EncryptionMethod(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"request_object_signing_alg_values_supported")) {
            config.requestObjectJWSAlgs = new LinkedHashSet<JWSAlgorithm>();
            if (jsonObject.get((Object)"request_object_signing_alg_values_supported") instanceof String) {
                config.requestObjectJWSAlgs.add(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "request_object_signing_alg_values_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "request_object_signing_alg_values_supported")) {
                    if (v == null) continue;
                    config.requestObjectJWSAlgs.add(new JWSAlgorithm(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"request_object_encryption_alg_values_supported")) {
            config.requestObjectJWEAlgs = new LinkedHashSet<JWEAlgorithm>();
            if (jsonObject.get((Object)"request_object_encryption_alg_values_supported") instanceof String) {
                config.requestObjectJWEAlgs.add(new JWEAlgorithm(JSONObjectUtils.getString(jsonObject, "request_object_encryption_alg_values_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "request_object_encryption_alg_values_supported")) {
                    if (v == null) continue;
                    config.requestObjectJWEAlgs.add(new JWEAlgorithm(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"request_object_encryption_enc_values_supported")) {
            config.requestObjectJWEEncs = new LinkedHashSet<EncryptionMethod>();
            if (jsonObject.get((Object)"request_object_encryption_enc_values_supported") instanceof String) {
                config.requestObjectJWEEncs.add(new EncryptionMethod(JSONObjectUtils.getString(jsonObject, "request_object_encryption_enc_values_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "request_object_encryption_enc_values_supported")) {
                    if (v == null) continue;
                    config.requestObjectJWEEncs.add(new EncryptionMethod(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"token_endpoint_auth_methods_supported")) {
            config.tokenEndpointAuthMethods = new LinkedHashSet<ClientAuthenticationMethod>();
            if (jsonObject.get((Object)"token_endpoint_auth_methods_supported") instanceof String) {
                config.tokenEndpointAuthMethods.add(new ClientAuthenticationMethod(JSONObjectUtils.getString(jsonObject, "token_endpoint_auth_methods_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "token_endpoint_auth_methods_supported")) {
                    if (v == null) continue;
                    config.tokenEndpointAuthMethods.add(new ClientAuthenticationMethod(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"token_endpoint_auth_signing_alg_values_supported")) {
            config.tokenEndpointJWSAlgs = new LinkedHashSet<JWSAlgorithm>();
            if (jsonObject.get((Object)"token_endpoint_auth_signing_alg_values_supported") instanceof String) {
                config.tokenEndpointJWSAlgs.add(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "token_endpoint_auth_signing_alg_values_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "token_endpoint_auth_signing_alg_values_supported")) {
                    if (v == null) continue;
                    config.tokenEndpointJWSAlgs.add(new JWSAlgorithm(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"display_values_supported")) {
            config.displays = new LinkedHashSet<Display>();
            if (jsonObject.get((Object)"display_values_supported") instanceof String) {
                config.displays.add(Display.parse(JSONObjectUtils.getString(jsonObject, "display_values_supported")));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "display_values_supported")) {
                    if (v == null) continue;
                    config.displays.add(Display.parse(v));
                }
            }
        }
        if (jsonObject.containsKey((Object)"claims_supported")) {
            config.claims = new LinkedHashSet<String>();
            if (jsonObject.get((Object)"claims_supported") instanceof String) {
                config.claims.add(JSONObjectUtils.getString(jsonObject, "claims_supported"));
            } else {
                for (String v : stringArray = JSONObjectUtils.getStringArray(jsonObject, "claims_supported")) {
                    if (v == null) continue;
                    config.claims.add(v);
                }
            }
        }
        if (jsonObject.containsKey((Object)"service_documentation")) {
            config.serviceDocsURL = JSONObjectUtils.getURL(jsonObject, "service_documentation");
        }
        return config;
    }

    public static ProviderConfiguration parse(String s) throws ParseException {
        return ProviderConfiguration.parse(JSONObjectUtils.parseJSONObject(s));
    }
}

