/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.rp;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagUtil;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.LangTaggedObject;
import com.nimbusds.openid.connect.sdk.rp.ApplicationType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import net.minidev.json.JSONObject;

public class Client {
    private ClientID id = null;
    private Set<URL> redirectURIs = null;
    private List<InternetAddress> contacts = null;
    private ApplicationType applicationType = ApplicationType.getDefault();
    private Map<LangTag, String> nameEntries = new HashMap<LangTag, String>();
    private URL logoURL = null;
    private URL policyURL = null;
    private URL tosURL = null;
    private SubjectType subjectType = null;
    private URL sectorIDURL = null;
    private ClientAuthenticationMethod tokenEndpointAuthMethod = ClientAuthenticationMethod.getDefault();
    private URL jwkSetURL = null;
    private URL encryptionJWKSetURL = null;
    private URL x509URL = null;
    private URL encryptionX509URL = null;
    private JWSAlgorithm requestObjectJWSAlg = null;
    private JWSAlgorithm idTokenJWSAlg = null;
    private JWEAlgorithm idTokenJWEAlg = null;
    private EncryptionMethod idTokenJWEEnc = null;
    private JWSAlgorithm userInfoJWSAlg = null;
    private JWEAlgorithm userInfoJWEAlg = null;
    private EncryptionMethod userInfoJWEEnc = null;
    private int defaultMaxAge = 0;
    private boolean requiresAuthTime = false;
    private Set<ACR> defaultACRs = null;
    private URL initiateLoginURI = null;
    private URL postLogoutRedirectURI = null;
    private BearerAccessToken accessToken = null;
    private Secret secret = null;

    public ClientID getID() {
        return this.id;
    }

    public void setID(ClientID id) {
        this.id = id;
    }

    public Set<URL> getRedirectURIs() {
        return this.redirectURIs;
    }

    public void setRedirectURIs(Set<URL> redirectURIs) {
        this.redirectURIs = redirectURIs;
    }

    public List<InternetAddress> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<InternetAddress> contacts) {
        this.contacts = contacts;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType == null ? ApplicationType.getDefault() : applicationType;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(LangTag langTag) {
        return this.nameEntries.get(langTag);
    }

    public Map<LangTag, String> getNameEntries() {
        return this.nameEntries;
    }

    public void setName(String name) {
        this.nameEntries.put(null, name);
    }

    public void setName(LangTaggedObject<String> name) {
        if (name == null) {
            return;
        }
        this.nameEntries.put(name.getLangTag(), name.getObject());
    }

    public URL getLogoURL() {
        return this.logoURL;
    }

    public void setLogoURL(URL logoURL) {
        this.logoURL = logoURL;
    }

    public URL getPolicyURL() {
        return this.policyURL;
    }

    public void setPolicyURL(URL policyURL) {
        this.policyURL = policyURL;
    }

    public URL getTermsOfServiceURL() {
        return this.tosURL;
    }

    public void setTermsOfServiceURL(URL tosURL) {
        this.tosURL = tosURL;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public URL getSectorIDURL() {
        return this.sectorIDURL;
    }

    public void setSectorIDURL(URL sectorIDURL) {
        this.sectorIDURL = sectorIDURL;
    }

    public ClientAuthenticationMethod getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(ClientAuthenticationMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod == null ? ClientAuthenticationMethod.getDefault() : tokenEndpointAuthMethod;
    }

    public URL getJWKSetURL() {
        return this.jwkSetURL;
    }

    public void setJWKSetURL(URL jwkSetURL) {
        this.jwkSetURL = jwkSetURL;
    }

    public URL getEncryptionJWKSetURL() {
        return this.encryptionJWKSetURL;
    }

    public void setEncrytionJWKSetURL(URL encryptionJWKSetURL) {
        this.encryptionJWKSetURL = encryptionJWKSetURL;
    }

    public URL getX509URL() {
        return this.x509URL;
    }

    public void setX509URL(URL x509URL) {
        this.x509URL = x509URL;
    }

    public URL getEncryptionX509URL() {
        return this.encryptionX509URL;
    }

    public void setEncryptionX509URL(URL encryptionX509URL) {
        this.encryptionX509URL = encryptionX509URL;
    }

    public JWSAlgorithm getRequestObjectJWSAlgorithm() {
        return this.requestObjectJWSAlg;
    }

    public void setRequestObjectJWSAlgorithm(JWSAlgorithm requestObjectJWSAlg) {
        this.requestObjectJWSAlg = requestObjectJWSAlg;
    }

    public JWSAlgorithm getIDTokenJWSAlgorithm() {
        return this.idTokenJWSAlg;
    }

    public void setIDTokenJWSAlgorithm(JWSAlgorithm idTokenJWSAlg) {
        this.idTokenJWSAlg = idTokenJWSAlg;
    }

    public JWEAlgorithm getIDTokenJWEAlgorithm() {
        return this.idTokenJWEAlg;
    }

    public void setIDTokenJWEAlgorithm(JWEAlgorithm idTokenJWEAlg) {
        this.idTokenJWEAlg = idTokenJWEAlg;
    }

    public EncryptionMethod getIDTokenJWEEncryptionMethod() {
        return this.idTokenJWEEnc;
    }

    public void setIDTokenJWEEncryptionMethod(EncryptionMethod idTokenJWEEnc) {
        this.idTokenJWEEnc = idTokenJWEEnc;
    }

    public JWSAlgorithm getUserInfoJWSAlgorithm() {
        return this.userInfoJWSAlg;
    }

    public void setUserInfoJWSAlgorithm(JWSAlgorithm userInfoJWSAlg) {
        this.userInfoJWSAlg = userInfoJWSAlg;
    }

    public JWEAlgorithm getUserInfoJWEAlgorithm() {
        return this.userInfoJWEAlg;
    }

    public void setUserInfoJWEAlgorithm(JWEAlgorithm userInfoJWEAlg) {
        this.userInfoJWEAlg = userInfoJWEAlg;
    }

    public EncryptionMethod getUserInfoJWEEncryptionMethod() {
        return this.userInfoJWEEnc;
    }

    public void setUserInfoJWEEncryptionMethod(EncryptionMethod userInfoJWEEnc) {
        this.userInfoJWEEnc = userInfoJWEEnc;
    }

    public int getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(int defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public boolean requiresAuthTime() {
        return this.requiresAuthTime;
    }

    public void requiresAuthTime(boolean requireAuthTime) {
        this.requiresAuthTime = this.requiresAuthTime;
    }

    public Set<ACR> getDefaultACRs() {
        return this.defaultACRs;
    }

    public void setDefaultACRs(Set<ACR> defaultACRs) {
        this.defaultACRs = defaultACRs;
    }

    public URL getInitiateLoginURI() {
        return this.initiateLoginURI;
    }

    public void setInitiateLoginURI(URL initiateLoginURI) {
        this.initiateLoginURI = initiateLoginURI;
    }

    public URL getPostLogoutRedirectURI() {
        return this.postLogoutRedirectURI;
    }

    public void setPostLogoutRedirectURI(URL postLogoutRedirectURI) {
        this.postLogoutRedirectURI = postLogoutRedirectURI;
    }

    public BearerAccessToken getRegistrationAccessToken() {
        return this.accessToken;
    }

    public void setRegistrationAccessToken(BearerAccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public void setSecret(Secret secret) {
        this.secret = secret;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        if (this.id != null) {
            o.put((Object)"client_id", (Object)this.id.getValue());
        }
        if (this.redirectURIs != null) {
            LinkedList<String> uriList = new LinkedList<String>();
            for (URL uri : this.redirectURIs) {
                uriList.add(uri.toString());
            }
            o.put((Object)"redirect_uris", uriList);
        }
        if (this.contacts != null) {
            LinkedList<String> contactList = new LinkedList<String>();
            for (InternetAddress email : this.contacts) {
                contactList.add(email.toString());
            }
            o.put((Object)"contacts", contactList);
        }
        o.put((Object)"application_type", (Object)this.applicationType.toString());
        if (!this.nameEntries.isEmpty()) {
            for (Map.Entry<LangTag, String> entry : this.nameEntries.entrySet()) {
                LangTag langTag = entry.getKey();
                if (langTag == null) {
                    o.put((Object)"client_name", (Object)entry.getValue());
                    continue;
                }
                o.put((Object)("client_name#" + langTag), (Object)entry.getValue());
            }
        }
        if (this.logoURL != null) {
            o.put((Object)"logo_url", (Object)this.logoURL.toString());
        }
        if (this.policyURL != null) {
            o.put((Object)"policy_url", (Object)this.policyURL.toString());
        }
        if (this.tosURL != null) {
            o.put((Object)"tos_url", (Object)this.tosURL.toString());
        }
        if (this.subjectType != null) {
            o.put((Object)"subject_type", (Object)this.subjectType.toString());
        }
        if (this.sectorIDURL != null) {
            o.put((Object)"sector_identifier_url", (Object)this.sectorIDURL.toString());
        }
        o.put((Object)"token_endpoint_auth_method", (Object)this.tokenEndpointAuthMethod.toString());
        if (this.jwkSetURL != null) {
            o.put((Object)"jwk_url", (Object)this.jwkSetURL.toString());
        }
        if (this.encryptionJWKSetURL != null) {
            o.put((Object)"jwk_encryption_url", (Object)this.encryptionJWKSetURL.toString());
        }
        if (this.x509URL != null) {
            o.put((Object)"x509_url", (Object)this.x509URL.toString());
        }
        if (this.encryptionX509URL != null) {
            o.put((Object)"x509_encryption_url", (Object)this.encryptionX509URL.toString());
        }
        if (this.requestObjectJWSAlg != null) {
            o.put((Object)"request_object_signing_alg", (Object)this.requestObjectJWSAlg.getName());
        }
        if (this.idTokenJWSAlg != null) {
            o.put((Object)"id_token_signed_response_alg", (Object)this.idTokenJWSAlg.getName());
        }
        if (this.idTokenJWEAlg != null) {
            o.put((Object)"id_token_encrypted_response_alg", (Object)this.idTokenJWEAlg.getName());
        }
        if (this.idTokenJWEEnc != null) {
            o.put((Object)"id_token_encrypted_response_enc", (Object)this.idTokenJWEEnc.getName());
        }
        if (this.userInfoJWSAlg != null) {
            o.put((Object)"userinfo_signed_response_alg", (Object)this.userInfoJWSAlg.getName());
        }
        if (this.userInfoJWEAlg != null) {
            o.put((Object)"userinfo_encrypted_response_alg", (Object)this.userInfoJWEAlg.getName());
        }
        if (this.userInfoJWEEnc != null) {
            o.put((Object)"userinfo_encrypted_response_enc", (Object)this.userInfoJWEEnc.getName());
        }
        if (this.defaultMaxAge > 0) {
            o.put((Object)"default_max_age", (Object)this.defaultMaxAge);
        }
        o.put((Object)"require_auth_time", (Object)this.requiresAuthTime);
        if (this.defaultACRs != null) {
            LinkedList<String> acrList = new LinkedList<String>();
            for (ACR acr : this.defaultACRs) {
                acrList.add(acr.getValue());
            }
            o.put((Object)"default_acr_values", acrList);
        }
        if (this.initiateLoginURI != null) {
            o.put((Object)"initiate_login_uri", (Object)this.initiateLoginURI.toString());
        }
        if (this.postLogoutRedirectURI != null) {
            o.put((Object)"post_logout_redirect_url", (Object)this.postLogoutRedirectURI.toString());
        }
        if (this.accessToken != null) {
            o.put((Object)"registration_access_token", (Object)this.accessToken.getValue());
        }
        if (this.secret != null) {
            o.put((Object)"client_secret", (Object)this.secret.getValue());
            if (this.secret.getExpirationDate() != null) {
                o.put((Object)"expires_at", (Object)this.secret.getExpirationDate().getTime());
            }
        }
        return o;
    }

    public static Client parse(JSONObject jsonObject) throws ParseException {
        Client client = new Client();
        if (jsonObject.containsKey((Object)"client_id")) {
            client.setID(new ClientID(JSONObjectUtils.getString(jsonObject, "client_id")));
        }
        if (jsonObject.containsKey((Object)"redirect_uris")) {
            LinkedHashSet<URL> redirectURIs = new LinkedHashSet<URL>();
            for (String uriString : JSONObjectUtils.getStringArray(jsonObject, "redirect_uris")) {
                try {
                    redirectURIs.add(new URL(uriString));
                }
                catch (MalformedURLException e) {
                    throw new ParseException("Invalid \"redirect_uris\" parameter: " + e.getMessage());
                }
            }
            client.setRedirectURIs(redirectURIs);
        }
        if (jsonObject.containsKey((Object)"contacts")) {
            LinkedList<InternetAddress> emailList = new LinkedList<InternetAddress>();
            for (String emailString : JSONObjectUtils.getStringArray(jsonObject, "contacts")) {
                try {
                    emailList.add(new InternetAddress(emailString));
                }
                catch (AddressException e) {
                    throw new ParseException("Invalid \"contacts\" parameter: " + e.getMessage());
                }
            }
            client.setContacts(emailList);
        }
        if (jsonObject.containsKey((Object)"application_type")) {
            client.setApplicationType(JSONObjectUtils.getEnum(jsonObject, "application_type", ApplicationType.class));
        }
        Map matches = LangTagUtil.find((String)"client_name", (Map)jsonObject);
        for (Map.Entry entry : matches.entrySet()) {
            try {
                client.setName(new LangTaggedObject<String>((String)entry.getValue(), (LangTag)entry.getKey()));
            }
            catch (ClassCastException e) {
                throw new ParseException("Invalid \"client_name\" (language tag) parameter");
            }
        }
        if (jsonObject.containsKey((Object)"client_name")) {
            client.setName(JSONObjectUtils.getString(jsonObject, "client_name"));
        }
        if (jsonObject.containsKey((Object)"logo_url")) {
            client.setLogoURL(JSONObjectUtils.getURL(jsonObject, "logo_url"));
        }
        if (jsonObject.containsKey((Object)"policy_url")) {
            client.setPolicyURL(JSONObjectUtils.getURL(jsonObject, "policy_url"));
        }
        if (jsonObject.containsKey((Object)"tos_url")) {
            client.setTermsOfServiceURL(JSONObjectUtils.getURL(jsonObject, "tos_url"));
        }
        if (jsonObject.containsKey((Object)"subject_type")) {
            client.setSubjectType(JSONObjectUtils.getEnum(jsonObject, "subject_type", SubjectType.class));
        }
        if (jsonObject.containsKey((Object)"sector_identifier_url")) {
            client.setSectorIDURL(JSONObjectUtils.getURL(jsonObject, "sector_identifier_url"));
        }
        if (jsonObject.containsKey((Object)"token_endpoint_auth_method")) {
            client.setTokenEndpointAuthMethod(new ClientAuthenticationMethod(JSONObjectUtils.getString(jsonObject, "token_endpoint_auth_method")));
        }
        if (jsonObject.containsKey((Object)"jwk_url")) {
            client.setJWKSetURL(JSONObjectUtils.getURL(jsonObject, "jwk_url"));
        }
        if (jsonObject.containsKey((Object)"jwk_encryption_url")) {
            client.setEncrytionJWKSetURL(JSONObjectUtils.getURL(jsonObject, "jwk_encryption_url"));
        }
        if (jsonObject.containsKey((Object)"x509_url")) {
            client.setX509URL(JSONObjectUtils.getURL(jsonObject, "x509_url"));
        }
        if (jsonObject.containsKey((Object)"x509_encryption_url")) {
            client.setEncryptionX509URL(JSONObjectUtils.getURL(jsonObject, "x509_encryption_url"));
        }
        if (jsonObject.containsKey((Object)"request_object_signing_alg")) {
            client.setRequestObjectJWSAlgorithm(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "request_object_signing_alg")));
        }
        if (jsonObject.containsKey((Object)"id_token_signed_response_alg")) {
            client.setIDTokenJWSAlgorithm(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "id_token_signed_response_alg")));
        }
        if (jsonObject.containsKey((Object)"id_token_encrypted_response_alg")) {
            client.setIDTokenJWEAlgorithm(new JWEAlgorithm(JSONObjectUtils.getString(jsonObject, "id_token_encrypted_response_alg")));
        }
        if (jsonObject.containsKey((Object)"id_token_encrypted_response_enc")) {
            client.setIDTokenJWEEncryptionMethod(new EncryptionMethod(JSONObjectUtils.getString(jsonObject, "id_token_encrypted_response_enc")));
        }
        if (jsonObject.containsKey((Object)"userinfo_signed_response_alg")) {
            client.setUserInfoJWSAlgorithm(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "userinfo_signed_response_alg")));
        }
        if (jsonObject.containsKey((Object)"userinfo_encrypted_response_alg")) {
            client.setUserInfoJWEAlgorithm(new JWEAlgorithm(JSONObjectUtils.getString(jsonObject, "userinfo_encrypted_response_alg")));
        }
        if (jsonObject.containsKey((Object)"userinfo_encrypted_response_enc")) {
            client.setUserInfoJWEEncryptionMethod(new EncryptionMethod(JSONObjectUtils.getString(jsonObject, "userinfo_encrypted_response_enc")));
        }
        if (jsonObject.containsKey((Object)"default_max_age")) {
            client.setDefaultMaxAge(JSONObjectUtils.getInt(jsonObject, "default_max_age"));
        }
        if (jsonObject.containsKey((Object)"require_auth_time")) {
            client.requiresAuthTime(JSONObjectUtils.getBoolean(jsonObject, "require_auth_time"));
        }
        if (jsonObject.containsKey((Object)"default_acr_values")) {
            LinkedHashSet<ACR> acrValues = new LinkedHashSet<ACR>();
            for (String acrString : JSONObjectUtils.getStringArray(jsonObject, "default_acr_values")) {
                acrValues.add(new ACR(acrString));
            }
            client.setDefaultACRs(acrValues);
        }
        if (jsonObject.containsKey((Object)"initiate_login_uri")) {
            client.setInitiateLoginURI(JSONObjectUtils.getURL(jsonObject, "initiate_login_uri"));
        }
        if (jsonObject.containsKey((Object)"post_logout_redirect_url")) {
            client.setPostLogoutRedirectURI(JSONObjectUtils.getURL(jsonObject, "post_logout_redirect_url"));
        }
        if (jsonObject.containsKey((Object)"registration_access_token")) {
            client.setRegistrationAccessToken(new BearerAccessToken(JSONObjectUtils.getString(jsonObject, "registration_access_token")));
        }
        if (jsonObject.containsKey((Object)"client_secret")) {
            String value = JSONObjectUtils.getString(jsonObject, "client_secret");
            Date exp = null;
            if (jsonObject.containsKey((Object)"expires_at")) {
                exp = new Date(JSONObjectUtils.getLong(jsonObject, "expires_at"));
            }
            client.setSecret(new Secret(value, exp));
        }
        return client;
    }
}

