/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.util;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeaderFilter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeaderFilter;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.PlainObject;
import com.nimbusds.openid.connect.sdk.util.JOSEObjectDecoder;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJOSEObjectDecoder
implements JOSEObjectDecoder {
    private final Map<JWSAlgorithm, JWSVerifier> jwsVerifiers = new Hashtable<JWSAlgorithm, JWSVerifier>();
    private final Map<JWEAlgorithm, JWEDecrypter> jweDecrypters = new Hashtable<JWEAlgorithm, JWEDecrypter>();

    public void addJWSVerifier(JWSVerifier verifier) {
        JWSHeaderFilter filter = verifier.getJWSHeaderFilter();
        for (JWSAlgorithm alg : filter.getAcceptedAlgorithms()) {
            this.jwsVerifiers.put(alg, verifier);
        }
    }

    public Collection<JWSVerifier> getJWSVerifiers() {
        return this.jwsVerifiers.values();
    }

    public void addJWEDecrypter(JWEDecrypter decrypter) {
        JWEHeaderFilter filter = decrypter.getJWEHeaderFilter();
        for (JWEAlgorithm alg : filter.getAcceptedAlgorithms()) {
            this.jweDecrypters.put(alg, decrypter);
        }
    }

    public Collection<JWEDecrypter> getJWEDecrypters() {
        return this.jweDecrypters.values();
    }

    private Payload verify(JWSObject jwsObject) throws JOSEException {
        JWSAlgorithm alg = jwsObject.getHeader().getAlgorithm();
        JWSVerifier verifier = this.jwsVerifiers.get(alg);
        if (verifier == null) {
            throw new JOSEException("Unsupported JWS algorithm: " + alg);
        }
        boolean verified = jwsObject.verify(verifier);
        if (!verified) {
            throw new JOSEException("Bad JWS signature");
        }
        return jwsObject.getPayload();
    }

    private Payload decrypt(JWEObject jweObject) throws JOSEException {
        JWEAlgorithm alg = jweObject.getHeader().getAlgorithm();
        JWEDecrypter decrypter = this.jweDecrypters.get(alg);
        if (decrypter == null) {
            throw new JOSEException("Unsupported JWE algorithm: " + alg);
        }
        jweObject.decrypt(decrypter);
        return jweObject.getPayload();
    }

    @Override
    public Payload decodeJOSEObject(JOSEObject joseObject) throws JOSEException {
        if (joseObject instanceof PlainObject) {
            PlainObject plainObject = (PlainObject)joseObject;
            return plainObject.getPayload();
        }
        if (joseObject instanceof JWSObject) {
            JWSObject jwsObject = (JWSObject)joseObject;
            return this.verify(jwsObject);
        }
        if (joseObject instanceof JWEObject) {
            JWEObject jweObject = (JWEObject)joseObject;
            return this.decrypt(jweObject);
        }
        throw new JOSEException("Unexpected JOSE object type: " + joseObject.getClass());
    }
}

