/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.util;

import com.nimbusds.jose.JOSEObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.util.JOSEObjectRetriever;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJOSEObjectRetriever
implements JOSEObjectRetriever {
    private final String lineSeparator;
    private int connectTimeout;
    private int readTimeout;

    public DefaultJOSEObjectRetriever() {
        this(0, 0);
    }

    public DefaultJOSEObjectRetriever(int connectTimeout, int readTimeout) {
        this.setConnectTimeout(connectTimeout);
        this.setReadTimeout(readTimeout);
        this.lineSeparator = System.getProperty("line.separator");
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("The connect timeout must not be negative");
        }
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException("The read timeout must not be negative");
        }
        this.readTimeout = readTimeout;
    }

    @Override
    public JOSEObject downloadJOSEObject(URL url) throws IOException, ParseException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setConnectTimeout(this.connectTimeout);
        con.setReadTimeout(this.readTimeout);
        StringBuilder sb = new StringBuilder();
        BufferedReader input = new BufferedReader(new InputStreamReader(con.getInputStream()));
        String line = null;
        while ((line = input.readLine()) != null) {
            sb.append(line);
            sb.append(this.lineSeparator);
        }
        input.close();
        int statusCode = con.getResponseCode();
        String statusMessage = con.getResponseMessage();
        try {
            return JOSEObject.parse((String)sb.toString());
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Couldn't parse JOSE object: " + e.getMessage(), e);
        }
    }
}

