/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class RefreshTokenRequest
extends TokenRequest {
    private final RefreshToken refreshToken;

    public RefreshTokenRequest(RefreshToken refreshToken) {
        this(refreshToken, null);
    }

    public RefreshTokenRequest(RefreshToken refreshToken, ClientAuthentication clientAuth) {
        super(GrantType.REFRESH_TOKEN, clientAuth);
        if (refreshToken == null) {
            throw new IllegalArgumentException("The refresh token must not be null");
        }
        this.refreshToken = refreshToken;
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public HTTPRequest toHTTPRequest(URL url) throws SerializeException {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, url);
        httpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", this.getGrantType().toString());
        params.put("refresh_token", this.refreshToken.getValue());
        httpRequest.setQuery(URLUtils.serializeParameters(params));
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(httpRequest);
        }
        return httpRequest;
    }

    public static RefreshTokenRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map<String, String> params = httpRequest.getQueryParameters();
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            throw new ParseException("Missing \"grant_type\" parameter");
        }
        GrantType grantType = new GrantType(grantTypeString);
        if (!grantType.equals(GrantType.REFRESH_TOKEN)) {
            throw new ParseException("Invalid \"grant_type\" parameter: " + grantTypeString);
        }
        String tokenString = params.get("refresh_token");
        if (tokenString == null) {
            throw new ParseException("Missing \"refresh_token\" parameter");
        }
        ClientAuthentication clientAuth = ClientAuthentication.parse(httpRequest);
        return new RefreshTokenRequest(new RefreshToken(tokenString), clientAuth);
    }
}

