/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.id;

import net.minidev.json.JSONAware;
import net.minidev.json.JSONValue;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class Identifier
implements JSONAware {
    private final String value;

    public Identifier(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("The value must not be null or empty string");
        }
        this.value = value;
    }

    public Identifier(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("The value must be a positive integer");
        }
        this.value = RandomStringUtils.randomAlphanumeric((int)length);
    }

    public Identifier() {
        this(32);
    }

    public String getValue() {
        return this.value;
    }

    public String toJSONString() {
        StringBuilder sb = new StringBuilder("\"");
        sb.append(JSONValue.escape((String)this.value));
        sb.append('\"');
        return sb.toString();
    }

    public String toString() {
        return this.getValue();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public abstract boolean equals(Object var1);
}

