/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import java.net.URL;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class OIDCClientReadRequest
extends ProtectedResourceRequest {
    public OIDCClientReadRequest(BearerAccessToken accessToken) {
        super(accessToken);
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
    }

    @Override
    public HTTPRequest toHTTPRequest(URL url) {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.GET, url);
        httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        return httpRequest;
    }

    public static OIDCClientReadRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.GET);
        String authzHeaderValue = httpRequest.getAuthorization();
        if (StringUtils.isBlank((CharSequence)authzHeaderValue)) {
            throw new ParseException("Missing HTTP Authorization header");
        }
        BearerAccessToken accessToken = BearerAccessToken.parse(authzHeaderValue);
        return new OIDCClientReadRequest(accessToken);
    }
}

