/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.rp.ClientDetails;
import java.net.URL;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

@Immutable
public final class OIDCClientRegisterRequest
extends ProtectedResourceRequest {
    private final ClientDetails client;

    public OIDCClientRegisterRequest(ClientDetails client, BearerAccessToken accessToken) {
        super(accessToken);
        if (client.getRedirectURIs() == null || client.getRedirectURIs().isEmpty()) {
            throw new IllegalArgumentException("The client details must specify one or more redirect URIs");
        }
        this.client = client;
    }

    public ClientDetails getClientDetails() {
        return this.client;
    }

    @Override
    public HTTPRequest toHTTPRequest(URL url) {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, url);
        if (this.getAccessToken() != null) {
            httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        }
        httpRequest.setContentType(CommonContentTypes.APPLICATION_JSON);
        httpRequest.setQuery(this.client.toJSONObject().toString());
        return httpRequest;
    }

    public static OIDCClientRegisterRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        JSONObject jsonObject = httpRequest.getQueryAsJSONObject();
        ClientDetails client = ClientDetails.parse(jsonObject);
        if (client.getRedirectURIs() == null || client.getRedirectURIs().isEmpty()) {
            throw new ParseException("The client details must specify one or more redirect URIs");
        }
        BearerAccessToken accessToken = null;
        String authzHeaderValue = httpRequest.getAuthorization();
        if (StringUtils.isNotBlank((CharSequence)authzHeaderValue)) {
            accessToken = BearerAccessToken.parse(authzHeaderValue);
        }
        return new OIDCClientRegisterRequest(client, accessToken);
    }
}

