/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.OIDCClientRegistrationResponse;
import com.nimbusds.openid.connect.sdk.OIDCError;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class OIDCClientRegistrationErrorResponse
extends OIDCClientRegistrationResponse
implements ErrorResponse {
    private final ErrorObject error;

    public static Set<ErrorObject> getStandardErrors() {
        HashSet<ErrorObject> stdErrors = new HashSet<ErrorObject>();
        stdErrors.add(BearerTokenError.MISSING_TOKEN);
        stdErrors.add(BearerTokenError.INVALID_REQUEST);
        stdErrors.add(BearerTokenError.INVALID_TOKEN);
        stdErrors.add(BearerTokenError.INSUFFICIENT_SCOPE);
        stdErrors.add(OIDCError.INVALID_REDIRECT_URI);
        stdErrors.add(OIDCError.INVALID_CLIENT_METADATA);
        return Collections.unmodifiableSet(stdErrors);
    }

    public OIDCClientRegistrationErrorResponse(ErrorObject error) {
        if (error == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = error;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = null;
        httpResponse = this.error.getHTTPStatusCode() > 0 ? new HTTPResponse(this.error.getHTTPStatusCode()) : new HTTPResponse(400);
        if (this.error != null && this.error instanceof BearerTokenError) {
            BearerTokenError bte = (BearerTokenError)this.error;
            httpResponse.setWWWAuthenticate(bte.toWWWAuthenticateHeader());
        } else {
            JSONObject jsonObject = new JSONObject();
            if (this.error.getCode() != null) {
                jsonObject.put((Object)"error", (Object)this.error.getCode());
            }
            if (this.error.getDescription() != null) {
                jsonObject.put((Object)"error_description", (Object)this.error.getDescription());
            }
            httpResponse.setContentType(CommonContentTypes.APPLICATION_JSON);
            httpResponse.setContent(jsonObject.toString());
        }
        return httpResponse;
    }

    public static OIDCClientRegistrationErrorResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCodeNotOK();
        ErrorObject error = null;
        String wwwAuth = httpResponse.getWWWAuthenticate();
        if (StringUtils.isNotBlank((CharSequence)wwwAuth)) {
            error = BearerTokenError.parse(wwwAuth);
        } else {
            JSONObject jsonObject = httpResponse.getContentAsJSONObject();
            String code = JSONObjectUtils.getString(jsonObject, "error");
            String description = null;
            if (jsonObject.containsKey((Object)"error_description")) {
                description = JSONObjectUtils.getString(jsonObject, "error_description");
            }
            error = new ErrorObject(code, description);
        }
        return new OIDCClientRegistrationErrorResponse(error);
    }
}

