/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.rp;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagUtil;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.rp.ApplicationType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class ClientDetails {
    private ClientID id;
    private URL registrationURI;
    private Set<URL> redirectURIs;
    private ResponseType responseTypes;
    private Set<GrantType> grantTypes;
    private ApplicationType applicationType;
    private List<InternetAddress> contacts;
    private Map<LangTag, String> nameEntries = new HashMap<LangTag, String>();
    private Map<LangTag, URL> logoURIEntries = new HashMap<LangTag, URL>();
    private Map<LangTag, URL> policyURIEntries = new HashMap<LangTag, URL>();
    private Map<LangTag, URL> tosURIEntries = new HashMap<LangTag, URL>();
    private SubjectType subjectType;
    private URL sectorIDURI;
    private ClientAuthenticationMethod authMethod;
    private URL jwkSetURI;
    private Set<URL> requestObjectURIs;
    private JWSAlgorithm requestObjectJWSAlg;
    private JWSAlgorithm idTokenJWSAlg;
    private JWEAlgorithm idTokenJWEAlg;
    private EncryptionMethod idTokenJWEEnc;
    private JWSAlgorithm userInfoJWSAlg;
    private JWEAlgorithm userInfoJWEAlg;
    private EncryptionMethod userInfoJWEEnc;
    private int defaultMaxAge;
    private boolean requiresAuthTime;
    private Set<ACR> defaultACRs;
    private URL initiateLoginURI;
    private URL postLogoutRedirectURI;
    private BearerAccessToken accessToken;
    private Secret secret;

    public ClientID getID() {
        return this.id;
    }

    public void setID(ClientID id) {
        this.id = id;
    }

    public URL getRegistrationURI() {
        return this.registrationURI;
    }

    public void setRegistrationURI(URL registrationURI) {
        this.registrationURI = registrationURI;
    }

    public Set<URL> getRedirectURIs() {
        return this.redirectURIs;
    }

    public void setRedirectURIs(Set<URL> redirectURIs) {
        this.redirectURIs = redirectURIs;
    }

    public ResponseType getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(ResponseType responseTypes) {
        this.responseTypes = responseTypes;
    }

    public Set<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(Set<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public List<InternetAddress> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<InternetAddress> contacts) {
        this.contacts = contacts;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(LangTag langTag) {
        return this.nameEntries.get(langTag);
    }

    public Map<LangTag, String> getNameEntries() {
        return this.nameEntries;
    }

    public void setName(String name) {
        this.nameEntries.put(null, name);
    }

    public void setName(String name, LangTag langTag) {
        this.nameEntries.put(langTag, name);
    }

    public URL getLogoURI() {
        return this.getLogoURI(null);
    }

    public URL getLogoURI(LangTag langTag) {
        return this.logoURIEntries.get(langTag);
    }

    public Map<LangTag, URL> getLogoURIEntries() {
        return this.logoURIEntries;
    }

    public void setLogoURI(URL logoURI) {
        this.logoURIEntries.put(null, logoURI);
    }

    public void setLogoURI(URL logoURI, LangTag langTag) {
        this.logoURIEntries.put(langTag, logoURI);
    }

    public URL getPolicyURI() {
        return this.getPolicyURI(null);
    }

    public URL getPolicyURI(LangTag langTag) {
        return this.policyURIEntries.get(langTag);
    }

    public Map<LangTag, URL> getPolicyURIEntries() {
        return this.policyURIEntries;
    }

    public void setPolicyURI(URL policyURI) {
        this.policyURIEntries.put(null, policyURI);
    }

    public void setPolicyURI(URL policyURI, LangTag langTag) {
        this.policyURIEntries.put(langTag, policyURI);
    }

    public URL getTermsOfServiceURI() {
        return this.getTermsOfServiceURI(null);
    }

    public URL getTermsOfServiceURI(LangTag langTag) {
        return this.tosURIEntries.get(langTag);
    }

    public Map<LangTag, URL> getTermsOfServiceURIEntries() {
        return this.tosURIEntries;
    }

    public void setTermsOfServiceURI(URL tosURI) {
        this.tosURIEntries.put(null, tosURI);
    }

    public void setTermsOfServiceURI(URL tosURI, LangTag langTag) {
        this.tosURIEntries.put(langTag, tosURI);
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public URL getSectorIDURI() {
        return this.sectorIDURI;
    }

    public void setSectorIDURI(URL sectorIDURI) {
        this.sectorIDURI = sectorIDURI;
    }

    public ClientAuthenticationMethod getTokenEndpointAuthMethod() {
        return this.authMethod;
    }

    public void setTokenEndpointAuthMethod(ClientAuthenticationMethod authMethod) {
        this.authMethod = authMethod;
    }

    public URL getJWKSetURI() {
        return this.jwkSetURI;
    }

    public void setJWKSetURL(URL jwkSetURI) {
        this.jwkSetURI = jwkSetURI;
    }

    public Set<URL> getRequestObjectURIs() {
        return this.requestObjectURIs;
    }

    public void setRequestObjectURIs(Set<URL> requestObjectURIs) {
        this.requestObjectURIs = requestObjectURIs;
    }

    public JWSAlgorithm getRequestObjectJWSAlgorithm() {
        return this.requestObjectJWSAlg;
    }

    public void setRequestObjectJWSAlgorithm(JWSAlgorithm requestObjectJWSAlg) {
        this.requestObjectJWSAlg = requestObjectJWSAlg;
    }

    public JWSAlgorithm getIDTokenJWSAlgorithm() {
        return this.idTokenJWSAlg;
    }

    public void setIDTokenJWSAlgorithm(JWSAlgorithm idTokenJWSAlg) {
        this.idTokenJWSAlg = idTokenJWSAlg;
    }

    public JWEAlgorithm getIDTokenJWEAlgorithm() {
        return this.idTokenJWEAlg;
    }

    public void setIDTokenJWEAlgorithm(JWEAlgorithm idTokenJWEAlg) {
        this.idTokenJWEAlg = idTokenJWEAlg;
    }

    public EncryptionMethod getIDTokenJWEEncryptionMethod() {
        return this.idTokenJWEEnc;
    }

    public void setIDTokenJWEEncryptionMethod(EncryptionMethod idTokenJWEEnc) {
        this.idTokenJWEEnc = idTokenJWEEnc;
    }

    public JWSAlgorithm getUserInfoJWSAlgorithm() {
        return this.userInfoJWSAlg;
    }

    public void setUserInfoJWSAlgorithm(JWSAlgorithm userInfoJWSAlg) {
        this.userInfoJWSAlg = userInfoJWSAlg;
    }

    public JWEAlgorithm getUserInfoJWEAlgorithm() {
        return this.userInfoJWEAlg;
    }

    public void setUserInfoJWEAlgorithm(JWEAlgorithm userInfoJWEAlg) {
        this.userInfoJWEAlg = userInfoJWEAlg;
    }

    public EncryptionMethod getUserInfoJWEEncryptionMethod() {
        return this.userInfoJWEEnc;
    }

    public void setUserInfoJWEEncryptionMethod(EncryptionMethod userInfoJWEEnc) {
        this.userInfoJWEEnc = userInfoJWEEnc;
    }

    public int getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(int defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public boolean requiresAuthTime() {
        return this.requiresAuthTime;
    }

    public void requiresAuthTime(boolean requiresAuthTime) {
        this.requiresAuthTime = requiresAuthTime;
    }

    public Set<ACR> getDefaultACRs() {
        return this.defaultACRs;
    }

    public void setDefaultACRs(Set<ACR> defaultACRs) {
        this.defaultACRs = defaultACRs;
    }

    public URL getInitiateLoginURI() {
        return this.initiateLoginURI;
    }

    public void setInitiateLoginURI(URL loginURI) {
        this.initiateLoginURI = loginURI;
    }

    public URL getPostLogoutRedirectURI() {
        return this.postLogoutRedirectURI;
    }

    public void setPostLogoutRedirectURI(URL logoutURI) {
        this.postLogoutRedirectURI = logoutURI;
    }

    public BearerAccessToken getRegistrationAccessToken() {
        return this.accessToken;
    }

    public void setRegistrationAccessToken(BearerAccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public void setSecret(Secret secret) {
        this.secret = secret;
    }

    public void applyDefaults() {
        if (this.responseTypes == null) {
            this.responseTypes = ResponseType.getDefault();
        }
        if (this.grantTypes == null) {
            this.grantTypes = new HashSet<GrantType>();
            this.grantTypes.add(GrantType.AUTHORIZATION_CODE);
        }
        if (this.applicationType == null) {
            this.applicationType = ApplicationType.getDefault();
        }
        if (this.authMethod == null) {
            this.authMethod = ClientAuthenticationMethod.getDefault();
        }
        if (this.idTokenJWSAlg == null) {
            this.idTokenJWSAlg = JWSAlgorithm.RS256;
        }
    }

    public JSONObject toJSONObject() {
        URL uri;
        LangTag langTag;
        JSONArray uriList;
        JSONObject o = new JSONObject();
        if (this.id != null) {
            o.put((Object)"client_id", (Object)this.id.getValue());
        }
        if (this.redirectURIs != null) {
            uriList = new JSONArray();
            for (URL uri2 : this.redirectURIs) {
                uriList.add((Object)uri2.toString());
            }
            o.put((Object)"redirect_uris", (Object)uriList);
        }
        if (this.registrationURI != null) {
            o.put((Object)"registration_client_uri", (Object)this.registrationURI.toString());
        }
        if (this.responseTypes != null) {
            JSONArray rtList = new JSONArray();
            for (ResponseType.Value rtValue : this.responseTypes) {
                rtList.add((Object)rtValue.toString());
            }
            o.put((Object)"response_types", (Object)rtList);
        }
        if (this.grantTypes != null) {
            JSONArray grantList = new JSONArray();
            for (GrantType grant : this.grantTypes) {
                grantList.add((Object)grant.toString());
            }
            o.put((Object)"grant_types", (Object)grantList);
        }
        if (this.applicationType != null) {
            o.put((Object)"application_type", (Object)this.applicationType.toString());
        }
        if (this.contacts != null) {
            JSONArray contactList = new JSONArray();
            for (InternetAddress email : this.contacts) {
                contactList.add((Object)email.toString());
            }
            o.put((Object)"contacts", (Object)contactList);
        }
        if (!this.nameEntries.isEmpty()) {
            for (Map.Entry<LangTag, String> entry : this.nameEntries.entrySet()) {
                langTag = entry.getKey();
                String name = entry.getValue();
                if (name == null) continue;
                if (langTag == null) {
                    o.put((Object)"client_name", (Object)entry.getValue());
                    continue;
                }
                o.put((Object)("client_name#" + langTag), (Object)entry.getValue());
            }
        }
        if (!this.logoURIEntries.isEmpty()) {
            for (Map.Entry<LangTag, Object> entry : this.logoURIEntries.entrySet()) {
                langTag = entry.getKey();
                uri = (URL)entry.getValue();
                if (uri == null) continue;
                if (langTag == null) {
                    o.put((Object)"logo_uri", entry.getValue());
                    continue;
                }
                o.put((Object)("logo_uri#" + langTag), (Object)((URL)entry.getValue()).toString());
            }
        }
        if (!this.policyURIEntries.isEmpty()) {
            for (Map.Entry<LangTag, Object> entry : this.policyURIEntries.entrySet()) {
                langTag = entry.getKey();
                uri = (URL)entry.getValue();
                if (uri == null) continue;
                if (langTag == null) {
                    o.put((Object)"policy_uri", entry.getValue());
                    continue;
                }
                o.put((Object)("policy_uri#" + langTag), (Object)((URL)entry.getValue()).toString());
            }
        }
        if (!this.tosURIEntries.isEmpty()) {
            for (Map.Entry<LangTag, Object> entry : this.tosURIEntries.entrySet()) {
                langTag = entry.getKey();
                uri = (URL)entry.getValue();
                if (uri == null) continue;
                if (langTag == null) {
                    o.put((Object)"tos_uri", entry.getValue());
                    continue;
                }
                o.put((Object)("tos_uri#" + langTag), (Object)((URL)entry.getValue()).toString());
            }
        }
        if (this.subjectType != null) {
            o.put((Object)"subject_type", (Object)this.subjectType.toString());
        }
        if (this.sectorIDURI != null) {
            o.put((Object)"sector_identifier_uri", (Object)this.sectorIDURI.toString());
        }
        if (this.authMethod != null) {
            o.put((Object)"token_endpoint_auth_method", (Object)this.authMethod.toString());
        }
        if (this.jwkSetURI != null) {
            o.put((Object)"jwks_uri", (Object)this.jwkSetURI.toString());
        }
        if (this.requestObjectURIs != null) {
            uriList = new JSONArray();
            for (URL uri2 : this.requestObjectURIs) {
                uriList.add((Object)uri2.toString());
            }
            o.put((Object)"request_uris", (Object)uriList);
        }
        if (this.requestObjectJWSAlg != null) {
            o.put((Object)"request_object_signing_alg", (Object)this.requestObjectJWSAlg.getName());
        }
        if (this.idTokenJWSAlg != null) {
            o.put((Object)"id_token_signed_response_alg", (Object)this.idTokenJWSAlg.getName());
        }
        if (this.idTokenJWEAlg != null) {
            o.put((Object)"id_token_encrypted_response_alg", (Object)this.idTokenJWEAlg.getName());
        }
        if (this.idTokenJWEEnc != null) {
            o.put((Object)"id_token_encrypted_response_enc", (Object)this.idTokenJWEEnc.getName());
        }
        if (this.userInfoJWSAlg != null) {
            o.put((Object)"userinfo_signed_response_alg", (Object)this.userInfoJWSAlg.getName());
        }
        if (this.userInfoJWEAlg != null) {
            o.put((Object)"userinfo_encrypted_response_alg", (Object)this.userInfoJWEAlg.getName());
        }
        if (this.userInfoJWEEnc != null) {
            o.put((Object)"userinfo_encrypted_response_enc", (Object)this.userInfoJWEEnc.getName());
        }
        if (this.defaultMaxAge > 0) {
            o.put((Object)"default_max_age", (Object)this.defaultMaxAge);
        }
        o.put((Object)"require_auth_time", (Object)this.requiresAuthTime);
        if (this.defaultACRs != null) {
            JSONArray acrList = new JSONArray();
            for (ACR acr : this.defaultACRs) {
                acrList.add((Object)acr);
            }
            o.put((Object)"default_acr_values", (Object)acrList);
        }
        if (this.initiateLoginURI != null) {
            o.put((Object)"initiate_login_uri", (Object)this.initiateLoginURI.toString());
        }
        if (this.postLogoutRedirectURI != null) {
            o.put((Object)"post_logout_redirect_uri", (Object)this.postLogoutRedirectURI.toString());
        }
        if (this.accessToken != null) {
            o.put((Object)"registration_access_token", (Object)this.accessToken.getValue());
        }
        if (this.secret != null) {
            o.put((Object)"client_secret", (Object)this.secret.getValue());
            if (this.secret.getExpirationDate() != null) {
                o.put((Object)"client_secret_expires_at", (Object)this.secret.getExpirationDate().getTime());
            }
        }
        return o;
    }

    public static ClientDetails parse(JSONObject jsonObject) throws ParseException {
        ClientDetails client = new ClientDetails();
        if (jsonObject.containsKey((Object)"client_id")) {
            client.setID(new ClientID(JSONObjectUtils.getString(jsonObject, "client_id")));
        }
        if (jsonObject.containsKey((Object)"registration_client_uri")) {
            client.setRegistrationURI(JSONObjectUtils.getURL(jsonObject, "registration_client_uri"));
        }
        if (jsonObject.containsKey((Object)"redirect_uris")) {
            LinkedHashSet<URL> redirectURIs = new LinkedHashSet<URL>();
            for (String uriString : JSONObjectUtils.getStringArray(jsonObject, "redirect_uris")) {
                try {
                    redirectURIs.add(new URL(uriString));
                }
                catch (MalformedURLException e) {
                    throw new ParseException("Invalid \"redirect_uris\" parameter: " + e.getMessage());
                }
            }
            client.setRedirectURIs(redirectURIs);
        }
        if (jsonObject.containsKey((Object)"response_types")) {
            ResponseType responseTypes = new ResponseType();
            for (String responseTypeValue : JSONObjectUtils.getStringArray(jsonObject, "response_types")) {
                responseTypes.add(new ResponseType.Value(responseTypeValue));
            }
            client.setResponseTypes(responseTypes);
        }
        if (jsonObject.containsKey((Object)"grant_types")) {
            LinkedHashSet<GrantType> grantTypes = new LinkedHashSet<GrantType>();
            for (String grant : JSONObjectUtils.getStringArray(jsonObject, "grant_types")) {
                grantTypes.add(new GrantType(grant));
            }
            client.setGrantTypes(grantTypes);
        }
        if (jsonObject.containsKey((Object)"application_type")) {
            client.setApplicationType(JSONObjectUtils.getEnum(jsonObject, "application_type", ApplicationType.class));
        }
        if (jsonObject.containsKey((Object)"contacts")) {
            LinkedList<InternetAddress> emailList = new LinkedList<InternetAddress>();
            for (String emailString : JSONObjectUtils.getStringArray(jsonObject, "contacts")) {
                try {
                    emailList.add(new InternetAddress(emailString));
                }
                catch (AddressException e) {
                    throw new ParseException("Invalid \"contacts\" parameter: " + e.getMessage());
                }
            }
            client.setContacts(emailList);
        }
        Map matches = LangTagUtil.find((String)"client_name", (Map)jsonObject);
        for (Map.Entry entry : matches.entrySet()) {
            try {
                client.setName((String)entry.getValue(), (LangTag)entry.getKey());
            }
            catch (ClassCastException e) {
                throw new ParseException("Invalid \"client_name\" (language tag) parameter");
            }
        }
        matches = LangTagUtil.find((String)"logo_uri", (Map)jsonObject);
        for (Map.Entry entry : matches.entrySet()) {
            try {
                client.setLogoURI(new URL((String)entry.getValue()), (LangTag)entry.getKey());
            }
            catch (Exception e) {
                throw new ParseException("Invalid \"logo_uri\" (language tag) parameter");
            }
        }
        matches = LangTagUtil.find((String)"policy_uri", (Map)jsonObject);
        for (Map.Entry entry : matches.entrySet()) {
            try {
                client.setPolicyURI(new URL((String)entry.getValue()), (LangTag)entry.getKey());
            }
            catch (Exception e) {
                throw new ParseException("Invalid \"policy_uri\" (language tag) parameter");
            }
        }
        matches = LangTagUtil.find((String)"tos_uri", (Map)jsonObject);
        for (Map.Entry entry : matches.entrySet()) {
            try {
                client.setTermsOfServiceURI(new URL((String)entry.getValue()), (LangTag)entry.getKey());
            }
            catch (Exception e) {
                throw new ParseException("Invalid \"tos_uri\" (language tag) parameter");
            }
        }
        if (jsonObject.containsKey((Object)"subject_type")) {
            client.setSubjectType(JSONObjectUtils.getEnum(jsonObject, "subject_type", SubjectType.class));
        }
        if (jsonObject.containsKey((Object)"sector_identifier_uri")) {
            client.setSectorIDURI(JSONObjectUtils.getURL(jsonObject, "sector_identifier_uri"));
        }
        if (jsonObject.containsKey((Object)"token_endpoint_auth_method")) {
            client.setTokenEndpointAuthMethod(new ClientAuthenticationMethod(JSONObjectUtils.getString(jsonObject, "token_endpoint_auth_method")));
        }
        if (jsonObject.containsKey((Object)"jwks_uri")) {
            client.setJWKSetURL(JSONObjectUtils.getURL(jsonObject, "jwks_uri"));
        }
        if (jsonObject.containsKey((Object)"request_uris")) {
            LinkedHashSet<URL> requestURIs = new LinkedHashSet<URL>();
            for (String uriString : JSONObjectUtils.getStringArray(jsonObject, "request_uris")) {
                try {
                    requestURIs.add(new URL(uriString));
                }
                catch (MalformedURLException e) {
                    throw new ParseException("Invalid \"request_uris\" parameter");
                }
            }
            client.setRequestObjectURIs(requestURIs);
        }
        if (jsonObject.containsKey((Object)"request_object_signing_alg")) {
            client.setRequestObjectJWSAlgorithm(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "request_object_signing_alg")));
        }
        if (jsonObject.containsKey((Object)"id_token_signed_response_alg")) {
            client.setIDTokenJWSAlgorithm(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "id_token_signed_response_alg")));
        }
        if (jsonObject.containsKey((Object)"id_token_encrypted_response_alg")) {
            client.setIDTokenJWEAlgorithm(new JWEAlgorithm(JSONObjectUtils.getString(jsonObject, "id_token_encrypted_response_alg")));
        }
        if (jsonObject.containsKey((Object)"id_token_encrypted_response_enc")) {
            client.setIDTokenJWEEncryptionMethod(new EncryptionMethod(JSONObjectUtils.getString(jsonObject, "id_token_encrypted_response_enc")));
        }
        if (jsonObject.containsKey((Object)"userinfo_signed_response_alg")) {
            client.setUserInfoJWSAlgorithm(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "userinfo_signed_response_alg")));
        }
        if (jsonObject.containsKey((Object)"userinfo_encrypted_response_alg")) {
            client.setUserInfoJWEAlgorithm(new JWEAlgorithm(JSONObjectUtils.getString(jsonObject, "userinfo_encrypted_response_alg")));
        }
        if (jsonObject.containsKey((Object)"userinfo_encrypted_response_enc")) {
            client.setUserInfoJWEEncryptionMethod(new EncryptionMethod(JSONObjectUtils.getString(jsonObject, "userinfo_encrypted_response_enc")));
        }
        if (jsonObject.containsKey((Object)"default_max_age")) {
            client.setDefaultMaxAge(JSONObjectUtils.getInt(jsonObject, "default_max_age"));
        }
        if (jsonObject.containsKey((Object)"require_auth_time")) {
            client.requiresAuthTime(JSONObjectUtils.getBoolean(jsonObject, "require_auth_time"));
        }
        if (jsonObject.containsKey((Object)"default_acr_values")) {
            LinkedHashSet<ACR> acrValues = new LinkedHashSet<ACR>();
            for (String acrString : JSONObjectUtils.getStringArray(jsonObject, "default_acr_values")) {
                acrValues.add(new ACR(acrString));
            }
            client.setDefaultACRs(acrValues);
        }
        if (jsonObject.containsKey((Object)"initiate_login_uri")) {
            client.setInitiateLoginURI(JSONObjectUtils.getURL(jsonObject, "initiate_login_uri"));
        }
        if (jsonObject.containsKey((Object)"post_logout_redirect_uri")) {
            client.setPostLogoutRedirectURI(JSONObjectUtils.getURL(jsonObject, "post_logout_redirect_uri"));
        }
        if (jsonObject.containsKey((Object)"registration_access_token")) {
            client.setRegistrationAccessToken(new BearerAccessToken(JSONObjectUtils.getString(jsonObject, "registration_access_token")));
        }
        if (jsonObject.containsKey((Object)"client_secret")) {
            String value = JSONObjectUtils.getString(jsonObject, "client_secret");
            Date exp = null;
            if (jsonObject.containsKey((Object)"client_secret_expires_at")) {
                exp = new Date(JSONObjectUtils.getLong(jsonObject, "client_secret_expires_at"));
            }
            client.setSecret(new Secret(value, exp));
        }
        return client;
    }
}

