/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AbstractRequest;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.URL;
import java.util.Map;

public class TokenRequest
extends AbstractRequest {
    private final ClientAuthentication clientAuth;
    private final AuthorizationGrant authzGrant;

    public TokenRequest(URL uri, ClientAuthentication clientAuth, AuthorizationGrant authzGrant) {
        super(uri);
        this.clientAuth = clientAuth;
        if (authzGrant == null) {
            throw new IllegalArgumentException("The authorization grant must not be null");
        }
        this.authzGrant = authzGrant;
    }

    public ClientAuthentication getClientAuthentication() {
        return this.clientAuth;
    }

    public AuthorizationGrant getAuthorizationGrant() {
        return this.authzGrant;
    }

    @Override
    public HTTPRequest toHTTPRequest() throws SerializeException {
        if (this.getURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getURI());
        httpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map<String, String> params = this.authzGrant.toParameters();
        httpRequest.setQuery(URLUtils.serializeParameters(params));
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(httpRequest);
        }
        return httpRequest;
    }

    public static TokenRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map<String, String> params = httpRequest.getQueryParameters();
        AuthorizationGrant authzGrant = AuthorizationGrant.parse(params);
        ClientAuthentication clientAuth = ClientAuthentication.parse(httpRequest);
        return new TokenRequest(httpRequest.getURL(), clientAuth, authzGrant);
    }
}

