/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.id;

import java.security.SecureRandom;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONValue;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public abstract class Identifier
implements JSONAware {
    public static final int DEFAULT_BYTE_LENGTH = 32;
    private static final SecureRandom secureRandom = new SecureRandom();
    private final String value;

    public Identifier(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("The value must not be null or empty string");
        }
        this.value = value;
    }

    public Identifier(int byteLength) {
        if (byteLength < 1) {
            throw new IllegalArgumentException("The byte length must be a positive integer");
        }
        byte[] n = new byte[byteLength];
        secureRandom.nextBytes(n);
        this.value = Base64.encodeBase64URLSafeString((byte[])n);
    }

    public Identifier() {
        this(32);
    }

    public String getValue() {
        return this.value;
    }

    public String toJSONString() {
        StringBuilder sb = new StringBuilder("\"");
        sb.append(JSONValue.escape((String)this.value));
        sb.append('\"');
        return sb.toString();
    }

    public String toString() {
        return this.getValue();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public abstract boolean equals(Object var1);
}

