/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.client;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagUtils;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.SoftwareID;
import com.nimbusds.oauth2.sdk.id.SoftwareVersion;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class ClientMetadata {
    private Set<URL> redirectURIs;
    private Scope scope;
    private Set<ResponseType> responseTypes;
    private Set<GrantType> grantTypes;
    private List<InternetAddress> contacts;
    private Map<LangTag, String> nameEntries;
    private Map<LangTag, URL> logoURIEntries;
    private Map<LangTag, URL> uriEntries;
    private Map<LangTag, URL> policyURIEntries;
    private Map<LangTag, URL> tosURIEntries;
    private ClientAuthenticationMethod authMethod;
    private URL jwkSetURI;
    private SoftwareID softwareID;
    private SoftwareVersion softwareVersion;
    private JSONObject customFields;

    public ClientMetadata() {
        this.nameEntries = new HashMap<LangTag, String>();
        this.logoURIEntries = new HashMap<LangTag, URL>();
        this.uriEntries = new HashMap<LangTag, URL>();
        this.policyURIEntries = new HashMap<LangTag, URL>();
        this.policyURIEntries = new HashMap<LangTag, URL>();
        this.tosURIEntries = new HashMap<LangTag, URL>();
        this.customFields = new JSONObject();
    }

    public ClientMetadata(ClientMetadata metadata) {
        this.redirectURIs = metadata.redirectURIs;
        this.scope = metadata.scope;
        this.responseTypes = metadata.responseTypes;
        this.grantTypes = metadata.grantTypes;
        this.contacts = metadata.contacts;
        this.nameEntries = metadata.nameEntries;
        this.logoURIEntries = metadata.logoURIEntries;
        this.uriEntries = metadata.uriEntries;
        this.policyURIEntries = metadata.policyURIEntries;
        this.tosURIEntries = metadata.tosURIEntries;
        this.authMethod = metadata.authMethod;
        this.jwkSetURI = metadata.jwkSetURI;
        this.customFields = metadata.customFields;
    }

    public Set<URL> getRedirectionURIs() {
        return this.redirectURIs;
    }

    public void setRedirectionURIs(Set<URL> redirectURIs) {
        this.redirectURIs = redirectURIs;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Set<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(Set<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public Set<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(Set<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public List<InternetAddress> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<InternetAddress> contacts) {
        this.contacts = contacts;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(LangTag langTag) {
        return this.nameEntries.get(langTag);
    }

    public Map<LangTag, String> getNameEntries() {
        return this.nameEntries;
    }

    public void setName(String name) {
        this.nameEntries.put(null, name);
    }

    public void setName(String name, LangTag langTag) {
        this.nameEntries.put(langTag, name);
    }

    public URL getLogoURI() {
        return this.getLogoURI(null);
    }

    public URL getLogoURI(LangTag langTag) {
        return this.logoURIEntries.get(langTag);
    }

    public Map<LangTag, URL> getLogoURIEntries() {
        return this.logoURIEntries;
    }

    public void setLogoURI(URL logoURI) {
        this.logoURIEntries.put(null, logoURI);
    }

    public void setLogoURI(URL logoURI, LangTag langTag) {
        this.logoURIEntries.put(langTag, logoURI);
    }

    public URL getURI() {
        return this.getURI(null);
    }

    public URL getURI(LangTag langTag) {
        return this.uriEntries.get(langTag);
    }

    public Map<LangTag, URL> getURIEntries() {
        return this.uriEntries;
    }

    public void setURI(URL uri) {
        this.uriEntries.put(null, uri);
    }

    public void setURI(URL uri, LangTag langTag) {
        this.uriEntries.put(langTag, uri);
    }

    public URL getPolicyURI() {
        return this.getPolicyURI(null);
    }

    public URL getPolicyURI(LangTag langTag) {
        return this.policyURIEntries.get(langTag);
    }

    public Map<LangTag, URL> getPolicyURIEntries() {
        return this.policyURIEntries;
    }

    public void setPolicyURI(URL policyURI) {
        this.policyURIEntries.put(null, policyURI);
    }

    public void setPolicyURI(URL policyURI, LangTag langTag) {
        this.policyURIEntries.put(langTag, policyURI);
    }

    public URL getTermsOfServiceURI() {
        return this.getTermsOfServiceURI(null);
    }

    public URL getTermsOfServiceURI(LangTag langTag) {
        return this.tosURIEntries.get(langTag);
    }

    public Map<LangTag, URL> getTermsOfServiceURIEntries() {
        return this.tosURIEntries;
    }

    public void setTermsOfServiceURI(URL tosURI) {
        this.tosURIEntries.put(null, tosURI);
    }

    public void setTermsOfServiceURI(URL tosURI, LangTag langTag) {
        this.tosURIEntries.put(langTag, tosURI);
    }

    public ClientAuthenticationMethod getTokenEndpointAuthMethod() {
        return this.authMethod;
    }

    public void setTokenEndpointAuthMethod(ClientAuthenticationMethod authMethod) {
        this.authMethod = authMethod;
    }

    public URL getJWKSetURI() {
        return this.jwkSetURI;
    }

    public void setJWKSetURL(URL jwkSetURI) {
        this.jwkSetURI = jwkSetURI;
    }

    public SoftwareID getSoftwareID() {
        return this.softwareID;
    }

    public void setSoftwareID(SoftwareID softwareID) {
        this.softwareID = softwareID;
    }

    public SoftwareVersion getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(SoftwareVersion softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public Object getCustomField(String name) {
        return this.customFields.get((Object)name);
    }

    public JSONObject getCustomFields() {
        return this.customFields;
    }

    public void setCustomField(String name, Object value) {
        this.customFields.put((Object)name, value);
    }

    public void setCustomFields(JSONObject customFields) {
        if (customFields == null) {
            throw new IllegalArgumentException("The custom fields JSON object must not be null");
        }
        this.customFields = customFields;
    }

    public void applyDefaults() {
        if (this.responseTypes == null) {
            this.responseTypes = new HashSet<ResponseType>();
            this.responseTypes.add(ResponseType.getDefault());
        }
        if (this.grantTypes == null) {
            this.grantTypes = new HashSet<GrantType>();
            this.grantTypes.add(GrantType.AUTHORIZATION_CODE);
        }
        if (this.authMethod == null) {
            this.authMethod = ClientAuthenticationMethod.getDefault();
        }
    }

    public JSONObject toJSONObject() {
        return this.toJSONObject(true);
    }

    public JSONObject toJSONObject(boolean includeCustomFields) {
        URL uri;
        LangTag langTag;
        JSONObject o = includeCustomFields ? new JSONObject((Map)this.customFields) : new JSONObject();
        if (this.redirectURIs != null) {
            JSONArray uriList = new JSONArray();
            for (URL uri2 : this.redirectURIs) {
                uriList.add((Object)uri2.toString());
            }
            o.put((Object)"redirect_uris", (Object)uriList);
        }
        if (this.scope != null) {
            o.put((Object)"scope", (Object)this.scope.toString());
        }
        if (this.responseTypes != null) {
            JSONArray rtList = new JSONArray();
            for (ResponseType rt : this.responseTypes) {
                rtList.add((Object)rt.toString());
            }
            o.put((Object)"response_types", (Object)rtList);
        }
        if (this.grantTypes != null) {
            JSONArray grantList = new JSONArray();
            for (GrantType grant : this.grantTypes) {
                grantList.add((Object)grant.toString());
            }
            o.put((Object)"grant_types", (Object)grantList);
        }
        if (this.contacts != null) {
            JSONArray contactList = new JSONArray();
            for (InternetAddress email : this.contacts) {
                contactList.add((Object)email.toString());
            }
            o.put((Object)"contacts", (Object)contactList);
        }
        if (!this.nameEntries.isEmpty()) {
            for (Map.Entry<LangTag, String> entry : this.nameEntries.entrySet()) {
                langTag = entry.getKey();
                String name = entry.getValue();
                if (name == null) continue;
                if (langTag == null) {
                    o.put((Object)"client_name", (Object)entry.getValue());
                    continue;
                }
                o.put((Object)("client_name#" + langTag), (Object)entry.getValue());
            }
        }
        if (!this.logoURIEntries.isEmpty()) {
            for (Map.Entry<LangTag, Object> entry : this.logoURIEntries.entrySet()) {
                langTag = entry.getKey();
                uri = (URL)entry.getValue();
                if (uri == null) continue;
                if (langTag == null) {
                    o.put((Object)"logo_uri", (Object)((URL)entry.getValue()).toString());
                    continue;
                }
                o.put((Object)("logo_uri#" + langTag), (Object)((URL)entry.getValue()).toString());
            }
        }
        if (!this.uriEntries.isEmpty()) {
            for (Map.Entry<LangTag, Object> entry : this.uriEntries.entrySet()) {
                langTag = entry.getKey();
                uri = (URL)entry.getValue();
                if (uri == null) continue;
                if (langTag == null) {
                    o.put((Object)"client_uri", (Object)((URL)entry.getValue()).toString());
                    continue;
                }
                o.put((Object)("client_uri#" + langTag), (Object)((URL)entry.getValue()).toString());
            }
        }
        if (!this.policyURIEntries.isEmpty()) {
            for (Map.Entry<LangTag, Object> entry : this.policyURIEntries.entrySet()) {
                langTag = entry.getKey();
                uri = (URL)entry.getValue();
                if (uri == null) continue;
                if (langTag == null) {
                    o.put((Object)"policy_uri", (Object)((URL)entry.getValue()).toString());
                    continue;
                }
                o.put((Object)("policy_uri#" + langTag), (Object)((URL)entry.getValue()).toString());
            }
        }
        if (!this.tosURIEntries.isEmpty()) {
            for (Map.Entry<LangTag, Object> entry : this.tosURIEntries.entrySet()) {
                langTag = entry.getKey();
                uri = (URL)entry.getValue();
                if (uri == null) continue;
                if (langTag == null) {
                    o.put((Object)"tos_uri", (Object)((URL)entry.getValue()).toString());
                    continue;
                }
                o.put((Object)("tos_uri#" + langTag), (Object)((URL)entry.getValue()).toString());
            }
        }
        if (this.authMethod != null) {
            o.put((Object)"token_endpoint_auth_method", (Object)this.authMethod.toString());
        }
        if (this.jwkSetURI != null) {
            o.put((Object)"jwks_uri", (Object)this.jwkSetURI.toString());
        }
        if (this.softwareID != null) {
            o.put((Object)"software_id", (Object)this.softwareID.getValue());
        }
        if (this.softwareVersion != null) {
            o.put((Object)"software_version", (Object)this.softwareVersion.getValue());
        }
        return o;
    }

    public static ClientMetadata parse(JSONObject jsonObject) throws ParseException {
        return ClientMetadata.parseFromModifiableJSONObject(new JSONObject((Map)jsonObject));
    }

    private static ClientMetadata parseFromModifiableJSONObject(JSONObject jsonObject) throws ParseException {
        ClientMetadata metadata = new ClientMetadata();
        if (jsonObject.containsKey((Object)"redirect_uris")) {
            LinkedHashSet<URL> redirectURIs = new LinkedHashSet<URL>();
            for (String uriString : JSONObjectUtils.getStringArray(jsonObject, "redirect_uris")) {
                try {
                    redirectURIs.add(new URL(uriString));
                }
                catch (MalformedURLException e) {
                    throw new ParseException("Invalid \"redirect_uris\" parameter: " + e.getMessage());
                }
            }
            metadata.setRedirectionURIs(redirectURIs);
            jsonObject.remove((Object)"redirect_uris");
        }
        if (jsonObject.containsKey((Object)"scope")) {
            metadata.setScope(Scope.parse(JSONObjectUtils.getString(jsonObject, "scope")));
            jsonObject.remove((Object)"scope");
        }
        if (jsonObject.containsKey((Object)"response_types")) {
            LinkedHashSet<ResponseType> responseTypes = new LinkedHashSet<ResponseType>();
            for (String rt : JSONObjectUtils.getStringArray(jsonObject, "response_types")) {
                responseTypes.add(ResponseType.parse(rt));
            }
            metadata.setResponseTypes(responseTypes);
            jsonObject.remove((Object)"response_types");
        }
        if (jsonObject.containsKey((Object)"grant_types")) {
            LinkedHashSet<GrantType> grantTypes = new LinkedHashSet<GrantType>();
            for (String grant : JSONObjectUtils.getStringArray(jsonObject, "grant_types")) {
                grantTypes.add(new GrantType(grant));
            }
            metadata.setGrantTypes(grantTypes);
            jsonObject.remove((Object)"grant_types");
        }
        if (jsonObject.containsKey((Object)"contacts")) {
            LinkedList<InternetAddress> emailList = new LinkedList<InternetAddress>();
            for (String emailString : JSONObjectUtils.getStringArray(jsonObject, "contacts")) {
                try {
                    emailList.add(new InternetAddress(emailString));
                }
                catch (AddressException e) {
                    throw new ParseException("Invalid \"contacts\" parameter: " + e.getMessage());
                }
            }
            metadata.setContacts(emailList);
            jsonObject.remove((Object)"contacts");
        }
        Map matches = LangTagUtils.find((String)"client_name", (Map)jsonObject);
        for (Map.Entry entry : matches.entrySet()) {
            try {
                metadata.setName((String)entry.getValue(), (LangTag)entry.getKey());
            }
            catch (ClassCastException e) {
                throw new ParseException("Invalid \"client_name\" (language tag) parameter");
            }
            ClientMetadata.removeMember(jsonObject, "client_name", (LangTag)entry.getKey());
        }
        matches = LangTagUtils.find((String)"logo_uri", (Map)jsonObject);
        for (Map.Entry entry : matches.entrySet()) {
            try {
                metadata.setLogoURI(new URL((String)entry.getValue()), (LangTag)entry.getKey());
            }
            catch (Exception e) {
                throw new ParseException("Invalid \"logo_uri\" (language tag) parameter");
            }
            ClientMetadata.removeMember(jsonObject, "logo_uri", (LangTag)entry.getKey());
        }
        matches = LangTagUtils.find((String)"client_uri", (Map)jsonObject);
        for (Map.Entry entry : matches.entrySet()) {
            try {
                metadata.setURI(new URL((String)entry.getValue()), (LangTag)entry.getKey());
            }
            catch (Exception e) {
                throw new ParseException("Invalid \"client_uri\" (language tag) parameter");
            }
            ClientMetadata.removeMember(jsonObject, "client_uri", (LangTag)entry.getKey());
        }
        matches = LangTagUtils.find((String)"policy_uri", (Map)jsonObject);
        for (Map.Entry entry : matches.entrySet()) {
            try {
                metadata.setPolicyURI(new URL((String)entry.getValue()), (LangTag)entry.getKey());
            }
            catch (Exception e) {
                throw new ParseException("Invalid \"policy_uri\" (language tag) parameter");
            }
            ClientMetadata.removeMember(jsonObject, "policy_uri", (LangTag)entry.getKey());
        }
        matches = LangTagUtils.find((String)"tos_uri", (Map)jsonObject);
        for (Map.Entry entry : matches.entrySet()) {
            try {
                metadata.setTermsOfServiceURI(new URL((String)entry.getValue()), (LangTag)entry.getKey());
            }
            catch (Exception e) {
                throw new ParseException("Invalid \"tos_uri\" (language tag) parameter");
            }
            ClientMetadata.removeMember(jsonObject, "tos_uri", (LangTag)entry.getKey());
        }
        if (jsonObject.containsKey((Object)"token_endpoint_auth_method")) {
            metadata.setTokenEndpointAuthMethod(new ClientAuthenticationMethod(JSONObjectUtils.getString(jsonObject, "token_endpoint_auth_method")));
            jsonObject.remove((Object)"token_endpoint_auth_method");
        }
        if (jsonObject.containsKey((Object)"jwks_uri")) {
            metadata.setJWKSetURL(JSONObjectUtils.getURL(jsonObject, "jwks_uri"));
            jsonObject.remove((Object)"jwks_uri");
        }
        if (jsonObject.containsKey((Object)"software_id")) {
            metadata.setSoftwareID(new SoftwareID(JSONObjectUtils.getString(jsonObject, "software_id")));
            jsonObject.remove((Object)"software_id");
        }
        if (jsonObject.containsKey((Object)"software_version")) {
            metadata.setSoftwareVersion(new SoftwareVersion(JSONObjectUtils.getString(jsonObject, "software_version")));
            jsonObject.remove((Object)"software_version");
        }
        metadata.customFields = jsonObject;
        return metadata;
    }

    private static void removeMember(JSONObject jsonObject, String name, LangTag langTag) {
        if (langTag == null) {
            jsonObject.remove((Object)name);
        } else {
            jsonObject.remove((Object)(name + "#" + langTag));
        }
    }
}

