/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.OIDCAuthorizationRequest;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ClaimsRequest {
    private final Map<ImmutablePair<String, LangTag>, Entry> idTokenClaims = new HashMap<ImmutablePair<String, LangTag>, Entry>();
    private final Map<ImmutablePair<String, LangTag>, Entry> userInfoClaims = new HashMap<ImmutablePair<String, LangTag>, Entry>();

    public void add(ClaimsRequest other) {
        if (other == null) {
            return;
        }
        this.idTokenClaims.putAll(other.idTokenClaims);
        this.userInfoClaims.putAll(other.userInfoClaims);
    }

    public void addIDTokenClaim(String claimName) {
        this.addIDTokenClaim(claimName, ClaimRequirement.VOLUNTARY);
    }

    public void addIDTokenClaim(String claimName, ClaimRequirement requirement) {
        this.addIDTokenClaim(claimName, requirement, null);
    }

    public void addIDTokenClaim(String claimName, ClaimRequirement requirement, LangTag langTag) {
        this.addIDTokenClaim(claimName, requirement, langTag, (String)null);
    }

    public void addIDTokenClaim(String claimName, ClaimRequirement requirement, LangTag langTag, String value) {
        this.addIDTokenClaim(new Entry(claimName, requirement, langTag, value));
    }

    public void addIDTokenClaim(String claimName, ClaimRequirement requirement, LangTag langTag, List<String> values) {
        this.addIDTokenClaim(new Entry(claimName, requirement, langTag, values));
    }

    public void addIDTokenClaim(Entry entry) {
        ImmutablePair key = new ImmutablePair((Object)entry.getClaimName(), (Object)entry.getLangTag());
        this.idTokenClaims.put((ImmutablePair<String, LangTag>)key, entry);
    }

    public Collection<Entry> getIDTokenClaims() {
        return Collections.unmodifiableCollection(this.idTokenClaims.values());
    }

    public Set<String> getIDTokenClaimNames(boolean withLangTag) {
        HashSet<String> names = new HashSet<String>();
        for (Entry en : this.idTokenClaims.values()) {
            names.add(en.getClaimName(withLangTag));
        }
        return Collections.unmodifiableSet(names);
    }

    public Entry removeIDTokenClaim(String claimName, LangTag langTag) {
        ImmutablePair key = new ImmutablePair((Object)claimName, (Object)langTag);
        return this.idTokenClaims.remove(key);
    }

    public Collection<Entry> removeIDTokenClaims(String claimName) {
        LinkedList<Entry> removedClaims = new LinkedList<Entry>();
        Iterator<Map.Entry<ImmutablePair<String, LangTag>, Entry>> it = this.idTokenClaims.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ImmutablePair<String, LangTag>, Entry> reqEntry = it.next();
            if (!((String)reqEntry.getKey().getLeft()).equals(claimName)) continue;
            removedClaims.add(reqEntry.getValue());
            it.remove();
        }
        return Collections.unmodifiableCollection(removedClaims);
    }

    public void addUserInfoClaim(String claimName) {
        this.addUserInfoClaim(claimName, ClaimRequirement.VOLUNTARY);
    }

    public void addUserInfoClaim(String claimName, ClaimRequirement requirement) {
        this.addUserInfoClaim(claimName, requirement, null);
    }

    public void addUserInfoClaim(String claimName, ClaimRequirement requirement, LangTag langTag) {
        this.addUserInfoClaim(claimName, requirement, langTag, (String)null);
    }

    public void addUserInfoClaim(String claimName, ClaimRequirement requirement, LangTag langTag, String value) {
        this.addUserInfoClaim(new Entry(claimName, requirement, langTag, value));
    }

    public void addUserInfoClaim(String claimName, ClaimRequirement requirement, LangTag langTag, List<String> values) {
        this.addUserInfoClaim(new Entry(claimName, requirement, langTag, values));
    }

    public void addUserInfoClaim(Entry entry) {
        ImmutablePair key = new ImmutablePair((Object)entry.getClaimName(), (Object)entry.getLangTag());
        this.userInfoClaims.put((ImmutablePair<String, LangTag>)key, entry);
    }

    public Collection<Entry> getUserInfoClaims() {
        return Collections.unmodifiableCollection(this.userInfoClaims.values());
    }

    public Set<String> getUserInfoClaimNames(boolean withLangTag) {
        HashSet<String> names = new HashSet<String>();
        for (Entry en : this.userInfoClaims.values()) {
            names.add(en.getClaimName(withLangTag));
        }
        return Collections.unmodifiableSet(names);
    }

    public Entry removeUserInfoClaim(String claimName, LangTag langTag) {
        ImmutablePair key = new ImmutablePair((Object)claimName, (Object)langTag);
        return this.userInfoClaims.remove(key);
    }

    public Collection<Entry> removeUserInfoClaims(String claimName) {
        LinkedList<Entry> removedClaims = new LinkedList<Entry>();
        Iterator<Map.Entry<ImmutablePair<String, LangTag>, Entry>> it = this.userInfoClaims.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ImmutablePair<String, LangTag>, Entry> reqEntry = it.next();
            if (!((String)reqEntry.getKey().getLeft()).equals(claimName)) continue;
            removedClaims.add(reqEntry.getValue());
            it.remove();
        }
        return Collections.unmodifiableCollection(removedClaims);
    }

    public JSONObject toJSONObject() {
        Collection<Entry> userInfoEntries;
        JSONObject o = new JSONObject();
        Collection<Entry> idTokenEntries = this.getIDTokenClaims();
        if (!idTokenEntries.isEmpty()) {
            o.put((Object)"id_token", (Object)Entry.toJSONObject(idTokenEntries));
        }
        if (!(userInfoEntries = this.getUserInfoClaims()).isEmpty()) {
            o.put((Object)"userinfo", (Object)Entry.toJSONObject(userInfoEntries));
        }
        return o;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope) {
        boolean switchToIDToken = responseType.contains(OIDCResponseTypeValue.ID_TOKEN) && !responseType.contains(ResponseType.Value.CODE) && !responseType.contains(ResponseType.Value.TOKEN);
        ClaimsRequest claimsRequest = new ClaimsRequest();
        for (Scope.Value value : scope) {
            Set<Entry> entries;
            if (value.equals(OIDCScopeValue.PROFILE)) {
                entries = OIDCScopeValue.PROFILE.toClaimsRequestEntries();
            } else if (value.equals(OIDCScopeValue.EMAIL)) {
                entries = OIDCScopeValue.EMAIL.toClaimsRequestEntries();
            } else if (value.equals(OIDCScopeValue.PHONE)) {
                entries = OIDCScopeValue.PHONE.toClaimsRequestEntries();
            } else {
                if (!value.equals(OIDCScopeValue.ADDRESS)) continue;
                entries = OIDCScopeValue.ADDRESS.toClaimsRequestEntries();
            }
            for (Entry en : entries) {
                if (switchToIDToken) {
                    claimsRequest.addIDTokenClaim(en);
                    continue;
                }
                claimsRequest.addUserInfoClaim(en);
            }
        }
        return claimsRequest;
    }

    public static ClaimsRequest resolve(OIDCAuthorizationRequest authzRequest) {
        ClaimsRequest mergedClaimsRequest = ClaimsRequest.resolve(authzRequest.getResponseType(), authzRequest.getScope());
        mergedClaimsRequest.add(authzRequest.getClaims());
        return mergedClaimsRequest;
    }

    public static ClaimsRequest parse(JSONObject jsonObject) {
        ClaimsRequest claimsRequest = new ClaimsRequest();
        try {
            if (jsonObject.containsKey((Object)"id_token")) {
                JSONObject idTokenObject = (JSONObject)jsonObject.get((Object)"id_token");
                Collection<Entry> idTokenClaims = Entry.parseEntries(idTokenObject);
                for (Entry entry : idTokenClaims) {
                    claimsRequest.addIDTokenClaim(entry);
                }
            }
            if (jsonObject.containsKey((Object)"userinfo")) {
                JSONObject userInfoObject = (JSONObject)jsonObject.get((Object)"userinfo");
                Collection<Entry> userInfoClaims = Entry.parseEntries(userInfoObject);
                for (Entry entry : userInfoClaims) {
                    claimsRequest.addUserInfoClaim(entry);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return claimsRequest;
    }

    @Immutable
    public static class Entry {
        private final String claimName;
        private final ClaimRequirement requirement;
        private final LangTag langTag;
        private final String value;
        private final List<String> values;

        public Entry(String claimName, LangTag langTag) {
            this(claimName, ClaimRequirement.VOLUNTARY, langTag, null, null);
        }

        public Entry(String claimName, ClaimRequirement requirement) {
            this(claimName, requirement, null, null, null);
        }

        public Entry(String claimName, ClaimRequirement requirement, LangTag langTag, String value) {
            this(claimName, requirement, langTag, value, null);
        }

        public Entry(String claimName, ClaimRequirement requirement, LangTag langTag, List<String> values) {
            this(claimName, requirement, langTag, null, values);
        }

        private Entry(String claimName, ClaimRequirement requirement, LangTag langTag, String value, List<String> values) {
            if (claimName == null) {
                throw new IllegalArgumentException("The claim name must not be null");
            }
            this.claimName = claimName;
            if (requirement == null) {
                throw new IllegalArgumentException("The claim requirement must not be null");
            }
            this.requirement = requirement;
            this.langTag = langTag;
            if (value != null && values == null) {
                this.value = value;
                this.values = null;
            } else if (value == null && values != null) {
                this.value = null;
                this.values = values;
            } else if (value == null && values == null) {
                this.value = null;
                this.values = null;
            } else {
                throw new IllegalArgumentException("Either value or values must be specified, but not both");
            }
        }

        public String getClaimName() {
            return this.claimName;
        }

        public String getClaimName(boolean withLangTag) {
            if (withLangTag && this.langTag != null) {
                return this.claimName + "#" + this.langTag.toString();
            }
            return this.claimName;
        }

        public ClaimRequirement getClaimRequirement() {
            return this.requirement;
        }

        public LangTag getLangTag() {
            return this.langTag;
        }

        public String getValue() {
            return this.value;
        }

        public List<String> getValues() {
            return this.values;
        }

        public static JSONObject toJSONObject(Collection<Entry> entries) {
            JSONObject o = new JSONObject();
            for (Entry entry : entries) {
                JSONObject entrySpec = null;
                if (entry.getValue() != null) {
                    entrySpec = new JSONObject();
                    entrySpec.put((Object)"value", (Object)entry.getValue());
                }
                if (entry.getValues() != null) {
                    entrySpec = new JSONObject();
                    entrySpec.put((Object)"values", entry.getValues());
                }
                if (entry.getClaimRequirement().equals((Object)ClaimRequirement.ESSENTIAL)) {
                    if (entrySpec == null) {
                        entrySpec = new JSONObject();
                    }
                    entrySpec.put((Object)"essential", (Object)true);
                }
                o.put((Object)entry.getClaimName(true), (Object)entrySpec);
            }
            return o;
        }

        public static Collection<Entry> parseEntries(JSONObject jsonObject) {
            LinkedList<Entry> entries = new LinkedList<Entry>();
            if (jsonObject.isEmpty()) {
                return entries;
            }
            for (Map.Entry member : jsonObject.entrySet()) {
                String claimName;
                LangTag langTag;
                block12: {
                    String claimNameWithOptLangTag = (String)member.getKey();
                    langTag = null;
                    if (claimNameWithOptLangTag.contains("#")) {
                        String[] parts = claimNameWithOptLangTag.split("#", 2);
                        claimName = parts[0];
                        try {
                            langTag = LangTag.parse((String)parts[1]);
                            break block12;
                        }
                        catch (LangTagException e) {
                            continue;
                        }
                    }
                    claimName = claimNameWithOptLangTag;
                }
                if (member.getValue() == null) {
                    entries.add(new Entry(claimName, langTag));
                    continue;
                }
                try {
                    boolean isEssential;
                    JSONObject entrySpec = (JSONObject)member.getValue();
                    ClaimRequirement requirement = ClaimRequirement.VOLUNTARY;
                    if (entrySpec.containsKey((Object)"essential") && (isEssential = ((Boolean)entrySpec.get((Object)"essential")).booleanValue())) {
                        requirement = ClaimRequirement.ESSENTIAL;
                    }
                    if (entrySpec.containsKey((Object)"value")) {
                        String expectedValue = (String)entrySpec.get((Object)"value");
                        entries.add(new Entry(claimName, requirement, langTag, expectedValue));
                        continue;
                    }
                    if (entrySpec.containsKey((Object)"values")) {
                        LinkedList<String> expectedValues = new LinkedList<String>();
                        for (Object v : (List)entrySpec.get((Object)"values")) {
                            expectedValues.add((String)v);
                        }
                        entries.add(new Entry(claimName, requirement, langTag, expectedValues));
                        continue;
                    }
                    entries.add(new Entry(claimName, requirement, langTag, (String)null));
                }
                catch (Exception e) {}
            }
            return entries;
        }
    }
}

