/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class TokenErrorResponse
extends TokenResponse
implements ErrorResponse {
    private static final Set<ErrorObject> stdErrors = new HashSet<ErrorObject>();
    private final ErrorObject error;

    public static Set<ErrorObject> getStandardErrors() {
        return Collections.unmodifiableSet(stdErrors);
    }

    protected TokenErrorResponse() {
        this.error = null;
    }

    public TokenErrorResponse(ErrorObject error) {
        if (error == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = error;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        if (this.error == null) {
            return o;
        }
        o.put((Object)"error", (Object)this.error.getCode());
        if (this.error.getDescription() != null) {
            o.put((Object)"error_description", (Object)this.error.getDescription());
        }
        if (this.error.getURI() != null) {
            o.put((Object)"error_uri", (Object)this.error.getURI().toString());
        }
        return o;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        int statusCode = this.error.getHTTPStatusCode() > 0 ? this.error.getHTTPStatusCode() : 400;
        HTTPResponse httpResponse = new HTTPResponse(statusCode);
        httpResponse.setContentType(CommonContentTypes.APPLICATION_JSON);
        httpResponse.setCacheControl("no-store");
        httpResponse.setPragma("no-cache");
        httpResponse.setContent(this.toJSONObject().toString());
        return httpResponse;
    }

    public static TokenErrorResponse parse(JSONObject jsonObject) throws ParseException {
        ErrorObject error;
        if (!jsonObject.containsKey((Object)"error")) {
            return new TokenErrorResponse();
        }
        try {
            String code = JSONObjectUtils.getString(jsonObject, "error");
            String description = null;
            if (jsonObject.containsKey((Object)"error_description")) {
                description = JSONObjectUtils.getString(jsonObject, "error_description");
            }
            URL uri = null;
            if (jsonObject.containsKey((Object)"error_uri")) {
                uri = new URL(JSONObjectUtils.getString(jsonObject, "error_uri"));
            }
            error = new ErrorObject(code, description, 400, uri);
        }
        catch (ParseException e) {
            throw new ParseException("Missing or invalid token error response parameter: " + e.getMessage(), e);
        }
        catch (MalformedURLException e) {
            throw new ParseException("Invalid error URI: " + e.getMessage(), e);
        }
        return new TokenErrorResponse(error);
    }

    public static TokenErrorResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCodeNotOK();
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return TokenErrorResponse.parse(jsonObject);
    }

    static {
        stdErrors.add(OAuth2Error.INVALID_REQUEST);
        stdErrors.add(OAuth2Error.INVALID_CLIENT);
        stdErrors.add(OAuth2Error.INVALID_GRANT);
        stdErrors.add(OAuth2Error.UNAUTHORIZED_CLIENT);
        stdErrors.add(OAuth2Error.UNSUPPORTED_GRANT_TYPE);
        stdErrors.add(OAuth2Error.INVALID_SCOPE);
    }
}

