/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.client;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.URL;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class ClientUpdateRequest
extends ProtectedResourceRequest {
    private final ClientID id;
    private final ClientMetadata metadata;
    private final Secret secret;

    public ClientUpdateRequest(URL uri, ClientID id, BearerAccessToken accessToken, ClientMetadata metadata, Secret secret) {
        super(uri, accessToken);
        if (id == null) {
            throw new IllegalArgumentException("The client identifier must not be null");
        }
        this.id = id;
        if (metadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.metadata = metadata;
        this.secret = secret;
    }

    public ClientID getClientID() {
        return this.id;
    }

    public ClientMetadata getClientMetadata() {
        return this.metadata;
    }

    public Secret getClientSecret() {
        return this.secret;
    }

    @Override
    public HTTPRequest toHTTPRequest() throws SerializeException {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.PUT, this.getEndpointURI());
        httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        httpRequest.setContentType(CommonContentTypes.APPLICATION_JSON);
        JSONObject jsonObject = this.metadata.toJSONObject();
        jsonObject.put((Object)"client_id", (Object)this.id.getValue());
        if (this.secret != null) {
            jsonObject.put((Object)"client_secret", (Object)this.secret.getValue());
        }
        httpRequest.setQuery(jsonObject.toString());
        return httpRequest;
    }

    public static ClientUpdateRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.PUT);
        String authzHeaderValue = httpRequest.getAuthorization();
        if (StringUtils.isBlank((CharSequence)authzHeaderValue)) {
            throw new ParseException("Missing HTTP Authorization header");
        }
        BearerAccessToken accessToken = BearerAccessToken.parse(authzHeaderValue);
        JSONObject jsonObject = httpRequest.getQueryAsJSONObject();
        ClientID id = new ClientID(JSONObjectUtils.getString(jsonObject, "client_id"));
        ClientMetadata metadata = ClientMetadata.parse(jsonObject);
        Secret clientSecret = null;
        if (jsonObject.get((Object)"client_secret") != null) {
            clientSecret = new Secret(JSONObjectUtils.getString(jsonObject, "client_secret"));
        }
        return new ClientUpdateRequest(httpRequest.getURL(), id, accessToken, metadata, clientSecret);
    }
}

