/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.reg;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.reg.ClientMetadata;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.URL;
import java.util.Date;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class ClientInformation {
    private final ClientID id;
    private final URL registrationURI;
    private final BearerAccessToken accessToken;
    private final ClientMetadata metadata;
    private final Secret secret;
    private final Date issueDate;

    public ClientInformation(ClientID id, URL registrationURI, BearerAccessToken accessToken, ClientMetadata metadata, Secret secret, Date issueDate) {
        if (id == null) {
            throw new IllegalArgumentException("The client identifier must not be null");
        }
        this.id = id;
        if (registrationURI == null) {
            throw new IllegalArgumentException("The client registration URI must not be null");
        }
        this.registrationURI = registrationURI;
        if (accessToken == null) {
            throw new IllegalArgumentException("The client registration access token must not be null");
        }
        this.accessToken = accessToken;
        if (metadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.metadata = metadata;
        this.secret = secret;
        this.issueDate = issueDate;
    }

    public ClientID getID() {
        return this.id;
    }

    public URL getRegistrationURI() {
        return this.registrationURI;
    }

    public BearerAccessToken getRegistrationAccessToken() {
        return this.accessToken;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public JSONObject toJSONObject() {
        JSONObject o = this.metadata.toJSONObject();
        o.put((Object)"client_id", (Object)this.id.getValue());
        o.put((Object)"registration_client_uri", (Object)this.registrationURI.toString());
        o.put((Object)"registration_access_token", (Object)this.accessToken.getValue());
        if (this.secret != null) {
            o.put((Object)"client_secret", (Object)this.secret.getValue());
            if (this.secret.getExpirationDate() != null) {
                o.put((Object)"client_secret_expires_at", (Object)(this.secret.getExpirationDate().getTime() / 1000L));
            }
        }
        if (this.issueDate != null) {
            o.put((Object)"client_id_issued_at", (Object)(this.issueDate.getTime() / 1000L));
        }
        return o;
    }

    public static ClientInformation parse(JSONObject jsonObject) throws ParseException {
        ClientID id = new ClientID(JSONObjectUtils.getString(jsonObject, "client_id"));
        URL registrationURI = JSONObjectUtils.getURL(jsonObject, "registration_client_uri");
        BearerAccessToken accessToken = new BearerAccessToken(JSONObjectUtils.getString(jsonObject, "registration_access_token"));
        ClientMetadata metadata = ClientMetadata.parse(jsonObject);
        Secret secret = null;
        if (jsonObject.containsKey((Object)"client_secret")) {
            String value = JSONObjectUtils.getString(jsonObject, "client_secret");
            Date exp = null;
            if (jsonObject.containsKey((Object)"client_secret_expires_at")) {
                exp = new Date(JSONObjectUtils.getLong(jsonObject, "client_secret_expires_at") * 1000L);
            }
            secret = new Secret(value, exp);
        }
        Date issueDate = null;
        if (jsonObject.containsKey((Object)"client_id_issued_at")) {
            issueDate = new Date(JSONObjectUtils.getLong(jsonObject, "client_id_issued_at") * 1000L);
        }
        return new ClientInformation(id, registrationURI, accessToken, metadata, secret, issueDate);
    }
}

