/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.reg;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.reg.ClientMetadata;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import java.net.URL;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class ClientRegistrationRequest
extends ProtectedResourceRequest {
    private final ClientMetadata metadata;

    public ClientRegistrationRequest(ClientMetadata metadata, BearerAccessToken accessToken) {
        super(accessToken);
        if (metadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.metadata = metadata;
    }

    public ClientMetadata getClientMetadata() {
        return this.metadata;
    }

    @Override
    public HTTPRequest toHTTPRequest(URL url) {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, url);
        if (this.getAccessToken() != null) {
            httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        }
        httpRequest.setContentType(CommonContentTypes.APPLICATION_JSON);
        httpRequest.setQuery(this.metadata.toJSONObject().toString());
        return httpRequest;
    }

    public static ClientRegistrationRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        JSONObject jsonObject = httpRequest.getQueryAsJSONObject();
        ClientMetadata metadata = ClientMetadata.parse(jsonObject);
        BearerAccessToken accessToken = null;
        String authzHeaderValue = httpRequest.getAuthorization();
        if (StringUtils.isNotBlank((CharSequence)authzHeaderValue)) {
            accessToken = BearerAccessToken.parse(authzHeaderValue);
        }
        return new ClientRegistrationRequest(metadata, accessToken);
    }
}

