/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.http;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPMessage;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;

@ThreadSafe
public final class HTTPRequest
extends HTTPMessage {
    private final Method method;
    private final URL url;
    private String authorization = null;
    private String query = null;

    public HTTPRequest(Method method, URL url) {
        if (method == null) {
            throw new IllegalArgumentException("The HTTP method must not be null");
        }
        this.method = method;
        if (url == null) {
            throw new IllegalArgumentException("The HTTP URL must not be null");
        }
        this.url = url;
    }

    public HTTPRequest(HttpServletRequest sr) throws IOException {
        this.method = Method.valueOf(sr.getMethod().toUpperCase());
        try {
            this.url = new URL(sr.getRequestURL().toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid request URL: " + e.getMessage(), e);
        }
        String ct = sr.getContentType();
        try {
            this.setContentType(sr.getContentType());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid Content-Type header value: " + e.getMessage(), e);
        }
        this.setAuthorization(sr.getHeader("Authorization"));
        if (this.method.equals((Object)Method.GET)) {
            this.setQuery(sr.getQueryString());
        } else if (this.method.equals((Object)Method.POST)) {
            String line;
            StringBuilder body = new StringBuilder(256);
            BufferedReader reader = sr.getReader();
            while ((line = reader.readLine()) != null) {
                body.append(line);
                body.append(System.getProperty("line.separator"));
            }
            reader.close();
            this.setQuery(body.toString());
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public URL getURL() {
        return this.url;
    }

    public void ensureMethod(Method expectedMethod) throws ParseException {
        if (this.method != expectedMethod) {
            throw new ParseException("The HTTP request method must be " + (Object)((Object)expectedMethod));
        }
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(String authz) {
        this.authorization = authz;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    private void ensureQuery() throws ParseException {
        if (this.query == null || this.query.isEmpty()) {
            throw new ParseException("Missing or empty HTTP query string / entity body");
        }
    }

    public Map<String, String> getQueryParameters() {
        return URLUtils.parseParameters(this.query);
    }

    public JSONObject getQueryAsJSONObject() throws ParseException {
        this.ensureContentType(CommonContentTypes.APPLICATION_JSON);
        this.ensureQuery();
        return JSONObjectUtils.parseJSONObject(this.query);
    }

    public HTTPResponse send() throws IOException {
        String line;
        URL finalURL;
        if (this.method.equals((Object)Method.GET) && this.query != null) {
            try {
                finalURL = new URL(this.url.toString() + "?" + this.query);
            }
            catch (MalformedURLException e) {
                throw new IOException("Couldn't append query string: " + e.getMessage(), e);
            }
        } else {
            finalURL = this.url;
        }
        HttpURLConnection conn = (HttpURLConnection)finalURL.openConnection();
        if (this.authorization != null) {
            conn.setRequestProperty("Authorization", this.authorization);
        }
        if (this.method.equals((Object)Method.POST)) {
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", CommonContentTypes.APPLICATION_URLENCODED.toString());
            if (this.query != null) {
                OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
                writer.write(this.query);
                writer.flush();
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder body = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            body.append(line);
            body.append(System.getProperty("line.separator"));
        }
        reader.close();
        HTTPResponse response = new HTTPResponse(conn.getResponseCode());
        String location = conn.getHeaderField("Location");
        if (location != null) {
            try {
                response.setLocation(new URL(location));
            }
            catch (MalformedURLException e) {
                throw new IOException("Couldn't parse Location header: " + e.getMessage(), e);
            }
        }
        try {
            response.setContentType(conn.getContentType());
        }
        catch (ParseException e) {
            throw new IOException("Couldn't parse Content-Type header: " + e.getMessage(), e);
        }
        response.setCacheControl(conn.getHeaderField("Cache-Control"));
        response.setPragma(conn.getHeaderField("Pragma"));
        response.setWWWAuthenticate(conn.getHeaderField("WWW-Authenticate"));
        String bodyContent = body.toString();
        if (!bodyContent.isEmpty()) {
            response.setContent(bodyContent);
        }
        return response;
    }

    public static enum Method {
        GET,
        POST,
        DELETE;

    }
}

