/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class AccessTokenRequest
extends TokenRequest {
    private final AuthorizationCode code;
    private final URL redirectURI;
    private final ClientID clientID;
    private final String username;
    private final String password;
    private final Scope scope;

    public AccessTokenRequest(URL uri, AuthorizationCode code, URL redirectURI, ClientID clientID) {
        super(uri, GrantType.AUTHORIZATION_CODE, null);
        if (code == null) {
            throw new IllegalArgumentException("The authorization code must not be null");
        }
        this.code = code;
        this.redirectURI = redirectURI;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.clientID = clientID;
        this.username = null;
        this.password = null;
        this.scope = null;
    }

    public AccessTokenRequest(URL uri, AuthorizationCode code, URL redirectURI, ClientAuthentication clientAuth) {
        super(uri, GrantType.AUTHORIZATION_CODE, clientAuth);
        if (code == null) {
            throw new IllegalArgumentException("The authorization code must not be null");
        }
        this.code = code;
        this.redirectURI = redirectURI;
        if (clientAuth == null) {
            throw new IllegalArgumentException("The client authentication must not be null");
        }
        this.clientID = null;
        this.username = null;
        this.password = null;
        this.scope = null;
    }

    public AccessTokenRequest(URL uri, String username, String password, Scope scope) {
        super(uri, GrantType.PASSWORD, null);
        if (username == null) {
            throw new IllegalArgumentException("The username must not be null");
        }
        this.username = username;
        if (password == null) {
            throw new IllegalArgumentException("The password must not be null");
        }
        this.password = password;
        this.scope = scope;
        this.code = null;
        this.redirectURI = null;
        this.clientID = null;
    }

    public AccessTokenRequest(URL uri, Scope scope, ClientAuthentication clientAuth) {
        super(uri, GrantType.CLIENT_CREDENTIALS, null);
        this.scope = scope;
        if (clientAuth == null) {
            throw new IllegalArgumentException("The client authentication must not be null");
        }
        this.code = null;
        this.redirectURI = null;
        this.clientID = null;
        this.username = null;
        this.password = null;
    }

    public AuthorizationCode getAuthorizationCode() {
        return this.code;
    }

    public URL getRedirectURI() {
        return this.redirectURI;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public HTTPRequest toHTTPRequest() throws SerializeException {
        if (this.getURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getURI());
        httpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", this.getGrantType().toString());
        if (this.getGrantType().equals(GrantType.AUTHORIZATION_CODE)) {
            params.put("code", this.code.toString());
            if (this.redirectURI != null) {
                params.put("redirect_uri", this.redirectURI.toString());
            }
            if (this.clientID != null) {
                params.put("client_id", this.clientID.getValue());
            }
        } else if (this.getGrantType().equals(GrantType.PASSWORD)) {
            params.put("username", this.username);
            params.put("password", this.password);
            if (this.scope != null) {
                params.put("scope", this.scope.toString());
            }
        } else if (this.getGrantType().equals(GrantType.CLIENT_CREDENTIALS)) {
            if (this.scope != null) {
                params.put("scope", this.scope.toString());
            }
        } else {
            throw new SerializeException("Unsupported grant type: " + this.getGrantType());
        }
        httpRequest.setQuery(URLUtils.serializeParameters(params));
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(httpRequest);
        }
        return httpRequest;
    }

    public static AccessTokenRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map<String, String> params = httpRequest.getQueryParameters();
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            throw new ParseException("Missing \"grant_type\" parameter");
        }
        GrantType grantType = new GrantType(grantTypeString);
        if (grantType.equals(GrantType.AUTHORIZATION_CODE)) {
            ClientAuthentication clientAuth;
            String codeString = params.get("code");
            if (codeString == null) {
                throw new ParseException("Missing \"code\" parameter");
            }
            AuthorizationCode code = new AuthorizationCode(codeString);
            String redirectURIString = params.get("redirect_uri");
            URL redirectURI = null;
            if (redirectURIString != null) {
                try {
                    redirectURI = new URL(redirectURIString);
                }
                catch (MalformedURLException e) {
                    throw new ParseException("Invalid \"redirect_uri\" parameter: " + e.getMessage(), e);
                }
            }
            String clientIDString = params.get("client_id");
            ClientID clientID = null;
            if (clientIDString != null) {
                clientID = new ClientID(clientIDString);
            }
            if ((clientAuth = ClientAuthentication.parse(httpRequest)) != null) {
                return new AccessTokenRequest(URLUtils.getBaseURL(httpRequest.getURL()), code, redirectURI, clientAuth);
            }
            if (clientID == null) {
                throw new ParseException("Missing \"client_id\" parameter");
            }
            return new AccessTokenRequest(URLUtils.getBaseURL(httpRequest.getURL()), code, redirectURI, clientID);
        }
        if (grantType.equals(GrantType.PASSWORD)) {
            String username = params.get("username");
            if (username == null) {
                throw new ParseException("Missing \"username\" parameter");
            }
            String password = params.get("password");
            if (password == null) {
                throw new ParseException("Missing \"password\" parameter");
            }
            Scope scope = Scope.parse(params.get("scope"));
            return new AccessTokenRequest(URLUtils.getBaseURL(httpRequest.getURL()), username, password, scope);
        }
        if (grantType.equals(GrantType.CLIENT_CREDENTIALS)) {
            Scope scope = Scope.parse(params.get("scope"));
            ClientAuthentication clientAuth = ClientAuthentication.parse(httpRequest);
            if (clientAuth == null) {
                throw new ParseException("Missing client authentication");
            }
            return new AccessTokenRequest(URLUtils.getBaseURL(httpRequest.getURL()), scope, clientAuth);
        }
        throw new ParseException("Unsupported grant type: " + grantType);
    }
}

