/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AbstractRequest;
import com.nimbusds.oauth2.sdk.AccessTokenRequest;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import java.net.URL;
import java.util.Map;

public abstract class TokenRequest
extends AbstractRequest {
    private final GrantType grantType;
    private final ClientAuthentication clientAuth;

    protected TokenRequest(URL uri, GrantType grantType, ClientAuthentication clientAuth) {
        super(uri);
        if (grantType == null) {
            throw new IllegalArgumentException("The grant type must not be null");
        }
        this.grantType = grantType;
        this.clientAuth = clientAuth;
    }

    public GrantType getGrantType() {
        return this.grantType;
    }

    public ClientAuthentication getClientAuthentication() {
        return this.clientAuth;
    }

    public static TokenRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map<String, String> params = httpRequest.getQueryParameters();
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            throw new ParseException("Missing \"grant_type\" parameter");
        }
        GrantType grantType = new GrantType(grantTypeString);
        if (grantType.equals(GrantType.AUTHORIZATION_CODE)) {
            return AccessTokenRequest.parse(httpRequest);
        }
        if (grantType.equals(GrantType.REFRESH_TOKEN)) {
            return RefreshTokenRequest.parse(httpRequest);
        }
        throw new ParseException("Unsupported \"grant_type\": " + grantType);
    }
}

