/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.SuccessResponse;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import javax.mail.internet.ContentType;
import net.jcip.annotations.Immutable;

@Immutable
public final class UserInfoSuccessResponse
extends UserInfoResponse
implements SuccessResponse {
    private final UserInfo claimsSet;
    private final JWT jwt;

    public UserInfoSuccessResponse(UserInfo claimsSet) {
        if (claimsSet == null) {
            throw new IllegalArgumentException("The claims must not be null");
        }
        this.claimsSet = claimsSet;
        this.jwt = null;
    }

    public UserInfoSuccessResponse(JWT jwt) {
        if (jwt == null) {
            throw new IllegalArgumentException("The claims JWT must not be null");
        }
        this.jwt = jwt;
        this.claimsSet = null;
    }

    public ContentType getContentType() {
        if (this.claimsSet != null) {
            return CommonContentTypes.APPLICATION_JSON;
        }
        return CommonContentTypes.APPLICATION_JWT;
    }

    public UserInfo getUserInfo() {
        return this.claimsSet;
    }

    public JWT getUserInfoJWT() {
        return this.jwt;
    }

    @Override
    public HTTPResponse toHTTPResponse() throws SerializeException {
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setContentType(this.getContentType());
        String content = null;
        if (this.claimsSet != null) {
            content = this.claimsSet.getJSONObject().toString();
        } else {
            try {
                content = this.jwt.serialize();
            }
            catch (IllegalStateException e) {
                throw new SerializeException("Couldn't serialize UserInfo claims JWT: " + e.getMessage(), e);
            }
        }
        httpResponse.setContent(content);
        return httpResponse;
    }

    public static UserInfoSuccessResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        httpResponse.ensureContentType();
        ContentType ct = httpResponse.getContentType();
        UserInfoSuccessResponse response = null;
        if (ct.match(CommonContentTypes.APPLICATION_JSON)) {
            UserInfo claimsSet = null;
            try {
                claimsSet = new UserInfo(httpResponse.getContentAsJSONObject());
            }
            catch (Exception e) {
                throw new ParseException("Couldn't parse UserInfo claims: " + e.getMessage(), e);
            }
            response = new UserInfoSuccessResponse(claimsSet);
        } else if (ct.match(CommonContentTypes.APPLICATION_JWT)) {
            JWT jwt = null;
            try {
                jwt = httpResponse.getContentAsJWT();
            }
            catch (ParseException e) {
                throw new ParseException("Couldn't parse UserInfo claims JWT: " + e.getMessage(), e);
            }
            response = new UserInfoSuccessResponse(jwt);
        } else {
            throw new ParseException("Unexpected Content-Type, must be " + CommonContentTypes.APPLICATION_JSON + " or " + CommonContentTypes.APPLICATION_JWT);
        }
        return response;
    }
}

