/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.util.Map;

public abstract class ClientAuthentication {
    private final ClientAuthenticationMethod method;

    protected ClientAuthentication(ClientAuthenticationMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("The client authentication method must not be null");
        }
        this.method = method;
    }

    public ClientAuthenticationMethod getMethod() {
        return this.method;
    }

    public static ClientAuthentication parse(HTTPRequest httpRequest) throws ParseException {
        if (httpRequest.getAuthorization() != null && httpRequest.getAuthorization().startsWith("Basic")) {
            return ClientSecretBasic.parse(httpRequest);
        }
        if (httpRequest.getMethod() != HTTPRequest.Method.POST && !httpRequest.getContentType().match(CommonContentTypes.APPLICATION_URLENCODED)) {
            return null;
        }
        String query = httpRequest.getQuery();
        if (query == null) {
            return null;
        }
        Map<String, String> params = URLUtils.parseParameters(query);
        if (params.containsKey("client_id") && params.containsKey("client_secret")) {
            return ClientSecretPost.parse(httpRequest);
        }
        if (params.containsKey("client_assertion") && params.containsKey("client_assertion_type")) {
            return JWTAuthentication.parse(httpRequest);
        }
        return null;
    }

    public abstract void applyTo(HTTPRequest var1) throws SerializeException;
}

