/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.Scope;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minidev.json.JSONObject;

public class OIDCScopeValue
extends Scope.Value {
    public static final OIDCScopeValue OPENID = new OIDCScopeValue("openid", Scope.Value.Requirement.REQUIRED, new String[]{"sub"});
    public static final OIDCScopeValue PROFILE = new OIDCScopeValue("profile", new String[]{"name", "family_name", "given_name", "middle_name", "nickname", "preferred_username", "profile", "picture", "website", "gender", "birthdate", "zoneinfo", "locale", "updated_at"});
    public static final OIDCScopeValue EMAIL = new OIDCScopeValue("email", new String[]{"email", "email_verified"});
    public static final OIDCScopeValue ADDRESS = new OIDCScopeValue("address", new String[]{"formatted", "street_address", "locality", "region", "postal_code", "country"});
    public static final OIDCScopeValue PHONE = new OIDCScopeValue("phone", new String[]{"phone_number", "phone_number_verified"});
    public static final OIDCScopeValue OFFLINE_ACCESS = new OIDCScopeValue("offline_access", null);
    private final Set<String> claims;

    private OIDCScopeValue(String value, Scope.Value.Requirement requirement, String[] claims) {
        super(value, requirement);
        this.claims = claims != null ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(claims))) : null;
    }

    private OIDCScopeValue(String value, String[] claims) {
        this(value, Scope.Value.Requirement.OPTIONAL, claims);
    }

    public Set<String> getClaims() {
        return this.claims;
    }

    public JSONObject getClaimsRequestJSONObject() {
        JSONObject req = new JSONObject();
        for (String claim : this.claims) {
            if (this.getRequirement() == Scope.Value.Requirement.REQUIRED) {
                JSONObject details = new JSONObject();
                details.put((Object)"essential", (Object)true);
                req.put((Object)claim, (Object)details);
                continue;
            }
            req.put((Object)claim, null);
        }
        return req;
    }
}

