/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretJWT;
import com.nimbusds.oauth2.sdk.auth.JWTAuthenticationClaimsSet;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.ContentType;
import net.minidev.json.JSONObject;

public abstract class JWTAuthentication
extends ClientAuthentication {
    public static final String CLIENT_ASSERTION_TYPE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    private final SignedJWT clientAssertion;
    private final ClientID clientID;

    protected JWTAuthentication(ClientAuthenticationMethod method, SignedJWT clientAssertion, ClientID clientID) {
        super(method);
        if (clientAssertion == null) {
            throw new IllegalArgumentException("The client assertion JWT must not be null");
        }
        this.clientAssertion = clientAssertion;
        this.clientID = clientID;
    }

    public SignedJWT getClientAssertion() {
        return this.clientAssertion;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public JWTAuthenticationClaimsSet getJWTAuthenticationClaimsSet() throws ParseException {
        JSONObject claimsSet = null;
        try {
            claimsSet = this.clientAssertion.getJWTClaimsSet().toJSONObject();
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Couldn't retrieve JSON object from the client assertion JWT");
        }
        if (claimsSet == null) {
            throw new ParseException("Couldn't retrieve JSON object from the client assertion JWT");
        }
        return JWTAuthenticationClaimsSet.parse(claimsSet);
    }

    public Map<String, String> toParameters() throws SerializeException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            params.put("client_assertion", this.clientAssertion.serialize());
        }
        catch (IllegalStateException e) {
            throw new SerializeException("Couldn't serialize JWT to a client assertion string: " + e.getMessage(), e);
        }
        params.put("client_assertion_type", CLIENT_ASSERTION_TYPE);
        if (this.clientID != null) {
            params.put("client_id", this.clientID.getValue());
        }
        return params;
    }

    @Override
    public void applyTo(HTTPRequest httpRequest) throws SerializeException {
        if (httpRequest.getMethod() != HTTPRequest.Method.POST) {
            throw new SerializeException("The HTTP request method must be POST");
        }
        ContentType ct = httpRequest.getContentType();
        if (ct == null) {
            throw new SerializeException("Missing HTTP Content-Type header");
        }
        if (!ct.match(CommonContentTypes.APPLICATION_URLENCODED)) {
            throw new SerializeException("The HTTP Content-Type header must be " + CommonContentTypes.APPLICATION_URLENCODED);
        }
        Map<String, String> params = httpRequest.getQueryParameters();
        params.putAll(this.toParameters());
        String queryString = URLUtils.serializeParameters(params);
        httpRequest.setQuery(queryString);
    }

    protected static void ensureClientAssertionType(Map<String, String> params) throws ParseException {
        String clientAssertionType = params.get("client_assertion_type");
        if (clientAssertionType == null) {
            throw new ParseException("Missing \"client_assertion_type\" parameter");
        }
        if (!clientAssertionType.equals(CLIENT_ASSERTION_TYPE)) {
            throw new ParseException("Invalid \"client_assertion_type\" parameter, must be urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        }
    }

    protected static SignedJWT parseClientAssertion(Map<String, String> params) throws ParseException {
        String clientAssertion = params.get("client_assertion");
        if (clientAssertion == null) {
            throw new ParseException("Missing \"client_assertion\" parameter");
        }
        try {
            return SignedJWT.parse((String)clientAssertion);
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Invalid \"client_assertion\" JWT: " + e.getMessage(), e);
        }
    }

    protected static ClientID parseClientID(Map<String, String> params) {
        String clientIDString = params.get("client_id");
        if (clientIDString == null) {
            return null;
        }
        return new ClientID(clientIDString);
    }

    public static JWTAuthentication parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        String query = httpRequest.getQuery();
        if (query == null) {
            throw new ParseException("Missing HTTP POST request entity body");
        }
        Map<String, String> params = URLUtils.parseParameters(query);
        JWSAlgorithm alg = JWTAuthentication.parseClientAssertion(params).getHeader().getAlgorithm();
        if (ClientSecretJWT.getSupportedJWAs().contains(alg)) {
            return ClientSecretJWT.parse(params);
        }
        if (PrivateKeyJWT.getSupportedJWAs().contains(alg)) {
            return PrivateKeyJWT.parse(params);
        }
        throw new ParseException("Unsupported signed JWT algorithm: " + alg);
    }
}

