/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class Secret {
    public static final int DEFAULT_BYTE_LENGTH = 32;
    private static final SecureRandom secureRandom = new SecureRandom();
    private byte[] value;
    private final Date expDate;

    public Secret(String value) {
        this(value, null);
    }

    public Secret(String value, Date expDate) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("The value must not be null or empty string");
        }
        this.value = value.getBytes(Charset.forName("utf-8"));
        this.expDate = expDate;
    }

    public Secret(int byteLength) {
        this(byteLength, null);
    }

    public Secret(int byteLength, Date expDate) {
        if (byteLength < 1) {
            throw new IllegalArgumentException("The byte length must be a positive integer");
        }
        byte[] n = new byte[byteLength];
        secureRandom.nextBytes(n);
        this.value = Base64.encodeBase64URLSafe((byte[])n);
        this.expDate = expDate;
    }

    public Secret() {
        this(32);
    }

    public String getValue() {
        if (ArrayUtils.isEmpty((byte[])this.value)) {
            return null;
        }
        return new String(this.value, Charset.forName("utf-8"));
    }

    public byte[] getValueBytes() {
        return this.value;
    }

    public void erase() {
        if (ArrayUtils.isEmpty((byte[])this.value)) {
            return;
        }
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = 0;
        }
        this.value = null;
    }

    public Date getExpirationDate() {
        return this.expDate;
    }

    public boolean expired() {
        if (this.expDate == null) {
            return false;
        }
        Date now = new Date();
        return !this.expDate.after(now);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Secret && this.getValue().equals(((Secret)object).getValue());
    }
}

