/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationErrorResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.OIDCAuthorizationResponse;
import com.nimbusds.openid.connect.sdk.OIDCError;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public class OIDCAuthorizationErrorResponse
extends AuthorizationErrorResponse
implements OIDCAuthorizationResponse {
    private static Set<ErrorObject> stdErrors = new HashSet<ErrorObject>();

    public static Set<ErrorObject> getStandardErrors() {
        return Collections.unmodifiableSet(stdErrors);
    }

    public OIDCAuthorizationErrorResponse(URL redirectURI, ErrorObject error, ResponseType rt, State state) {
        super(redirectURI, error, rt, state);
    }

    public static OIDCAuthorizationErrorResponse parse(URL redirectURI, Map<String, String> params) throws ParseException {
        AuthorizationErrorResponse resp = AuthorizationErrorResponse.parse(redirectURI, params);
        return new OIDCAuthorizationErrorResponse(resp.getRedirectURI(), resp.getErrorObject(), resp.getResponseType(), resp.getState());
    }

    public static OIDCAuthorizationErrorResponse parse(URL uri) throws ParseException {
        AuthorizationErrorResponse resp = AuthorizationErrorResponse.parse(uri);
        return new OIDCAuthorizationErrorResponse(resp.getRedirectURI(), resp.getErrorObject(), resp.getResponseType(), resp.getState());
    }

    public static OIDCAuthorizationErrorResponse parse(HTTPResponse httpResponse) throws ParseException {
        AuthorizationErrorResponse resp = AuthorizationErrorResponse.parse(httpResponse);
        return new OIDCAuthorizationErrorResponse(resp.getRedirectURI(), resp.getErrorObject(), resp.getResponseType(), resp.getState());
    }

    static {
        stdErrors.addAll(AuthorizationErrorResponse.getStandardErrors());
        stdErrors.add(OIDCError.INTERACTION_REQUIRED);
        stdErrors.add(OIDCError.LOGIN_REQUIRED);
        stdErrors.add(OIDCError.SESSION_SELECTION_REQUIRED);
        stdErrors.add(OIDCError.CONSENT_REQUIRED);
        stdErrors.add(OIDCError.INVALID_REQUEST_URI);
        stdErrors.add(OIDCError.INVALID_REQUEST_OBJECT);
        stdErrors.add(OIDCError.REGISTRATION_NOT_SUPPORTED);
        stdErrors.add(OIDCError.REQUEST_NOT_SUPPORTED);
        stdErrors.add(OIDCError.REQUEST_URI_NOT_SUPPORTED);
    }
}

