/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.op;

import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import com.nimbusds.openid.connect.sdk.OIDCAuthorizationRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class ACRRequest {
    private final List<ACR> essentialACRs;
    private final List<ACR> voluntaryACRs;

    public ACRRequest(List<ACR> essentialACRs, List<ACR> voluntaryACRs) {
        this.essentialACRs = essentialACRs;
        this.voluntaryACRs = voluntaryACRs;
    }

    public List<ACR> getEssentialACRs() {
        return this.essentialACRs;
    }

    public List<ACR> getVoluntaryACRs() {
        return this.voluntaryACRs;
    }

    public boolean noValuesSpecified() {
        if (this.essentialACRs != null && !this.essentialACRs.isEmpty()) {
            return false;
        }
        return this.voluntaryACRs == null || this.voluntaryACRs.isEmpty();
    }

    public static ACRRequest resolve(OIDCAuthorizationRequest authzRequest) {
        List<ACR> topLevelACRs;
        ArrayList<ACR> essentialACRs = null;
        ArrayList<ACR> voluntaryACRs = null;
        ClaimsRequest claimsRequest = authzRequest.getClaims();
        if (claimsRequest != null) {
            for (ClaimsRequest.Entry claimEntry : claimsRequest.getIDTokenClaims()) {
                if (!claimEntry.getClaimName().equals("acr")) continue;
                if (claimEntry.getClaimRequirement().equals((Object)ClaimRequirement.ESSENTIAL)) {
                    essentialACRs = new ArrayList<ACR>();
                    if (claimEntry.getValue() != null) {
                        essentialACRs.add(new ACR(claimEntry.getValue()));
                    }
                    if (claimEntry.getValues() == null) continue;
                    for (String v : claimEntry.getValues()) {
                        essentialACRs.add(new ACR(v));
                    }
                    continue;
                }
                voluntaryACRs = new ArrayList();
                if (claimEntry.getValue() != null) {
                    voluntaryACRs.add(new ACR(claimEntry.getValue()));
                }
                if (claimEntry.getValues() == null) continue;
                for (String v : claimEntry.getValues()) {
                    voluntaryACRs.add(new ACR(v));
                }
            }
        }
        if ((topLevelACRs = authzRequest.getACRValues()) != null) {
            if (voluntaryACRs == null) {
                voluntaryACRs = new ArrayList<ACR>();
            }
            voluntaryACRs.addAll(topLevelACRs);
        }
        return new ACRRequest(essentialACRs, (List<ACR>)voluntaryACRs);
    }
}

