/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.op;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.Display;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minidev.json.JSONObject;

public class OIDCProviderMetadata {
    public static final String VERSION = "3.0";
    private final Issuer issuer;
    private URL authzEndpoint;
    private URL tokenEndpoint;
    private URL userInfoEndpoint;
    private URL regEndpoint;
    private URL checkSessionIframe;
    private URL endSessionEndpoint;
    private URL jwkSetURI;
    private Scope scope;
    private List<ResponseType> rts;
    private List<GrantType> gts;
    private List<ACR> acrValues;
    private final List<SubjectType> subjectTypes;
    private List<ClientAuthenticationMethod> tokenEndpointAuthMethods;
    private List<JWSAlgorithm> tokenEndpointJWSAlgs;
    private List<JWSAlgorithm> requestObjectJWSAlgs;
    private List<JWEAlgorithm> requestObjectJWEAlgs;
    private List<EncryptionMethod> requestObjectJWEEncs;
    private List<JWSAlgorithm> idTokenJWSAlgs;
    private List<JWEAlgorithm> idTokenJWEAlgs;
    private List<EncryptionMethod> idTokenJWEEncs;
    private List<JWSAlgorithm> userInfoJWSAlgs;
    private List<JWEAlgorithm> userInfoJWEAlgs;
    private List<EncryptionMethod> userInfoJWEEncs;
    private List<Display> displays;
    private List<ClaimType> claimTypes;
    private List<String> claims;
    private List<LangTag> claimsLocales;
    private List<LangTag> uiLocales;
    private URL serviceDocsURL;
    private URL policyURI;
    private URL tosURI;
    private boolean claimsParamSupported;
    private boolean requestParamSupported;
    private boolean requestURIParamSupported;
    private boolean requireRequestURIReg;

    protected OIDCProviderMetadata(Issuer issuer, List<SubjectType> subjectTypes) {
        URL url = null;
        try {
            url = new URL(issuer.getValue());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The issuer identifer must be a URL: " + e.getMessage(), e);
        }
        if (url.getQuery() != null) {
            throw new IllegalArgumentException("The issuer URL must be without a query component");
        }
        if (url.getRef() != null) {
            throw new IllegalArgumentException("The issuer URL must be without a fragment component ");
        }
        this.issuer = issuer;
        if (subjectTypes.size() < 1) {
            throw new IllegalArgumentException("At least one supported subject type must be specified");
        }
        this.subjectTypes = subjectTypes;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public URL getAuthorizationEndpointURL() {
        return this.authzEndpoint;
    }

    public URL getTokenEndpointURL() {
        return this.tokenEndpoint;
    }

    public URL getUserInfoEndpointURL() {
        return this.userInfoEndpoint;
    }

    public URL getRegistrationEndpointURL() {
        return this.regEndpoint;
    }

    public URL getCheckSessionIframeURL() {
        return this.checkSessionIframe;
    }

    public URL getEndSessionEndpointURL() {
        return this.endSessionEndpoint;
    }

    public URL getJWKSetURI() {
        return this.jwkSetURI;
    }

    public Scope getScopes() {
        return this.scope;
    }

    public List<ResponseType> getResponseTypes() {
        return this.rts;
    }

    public List<GrantType> getGrantTypes() {
        return this.gts;
    }

    public List<ACR> getACRs() {
        return this.acrValues;
    }

    public List<SubjectType> getSubjectTypes() {
        return this.subjectTypes;
    }

    public List<ClientAuthenticationMethod> getTokenEndpointAuthMethods() {
        return this.tokenEndpointAuthMethods;
    }

    public List<JWSAlgorithm> getTokenEndpointJWSAlgs() {
        return this.tokenEndpointJWSAlgs;
    }

    public List<JWSAlgorithm> getRequestObjectJWSAlgs() {
        return this.requestObjectJWSAlgs;
    }

    public List<JWEAlgorithm> getRequestObjectJWEAlgs() {
        return this.requestObjectJWEAlgs;
    }

    public List<EncryptionMethod> getRequestObjectJWEEncs() {
        return this.requestObjectJWEEncs;
    }

    public List<JWSAlgorithm> getIDTokenJWSAlgs() {
        return this.idTokenJWSAlgs;
    }

    public List<JWEAlgorithm> getIDTokenJWEAlgs() {
        return this.idTokenJWEAlgs;
    }

    public List<EncryptionMethod> getIDTokenJWEEncs() {
        return this.idTokenJWEEncs;
    }

    public List<JWSAlgorithm> getUserInfoJWSAlgs() {
        return this.idTokenJWSAlgs;
    }

    public List<JWEAlgorithm> getUserInfoJWEAlgs() {
        return this.idTokenJWEAlgs;
    }

    public List<EncryptionMethod> getUserInfoJWEEncs() {
        return this.idTokenJWEEncs;
    }

    public List<Display> getDisplays() {
        return this.displays;
    }

    public List<ClaimType> getClaimTypes() {
        return this.claimTypes;
    }

    public List<String> getClaims() {
        return this.claims;
    }

    public List<LangTag> getClaimsLocales() {
        return this.claimsLocales;
    }

    public List<LangTag> getUILocales() {
        return this.uiLocales;
    }

    public URL getServiceDocsURL() {
        return this.serviceDocsURL;
    }

    public URL getPolicyURI() {
        return this.policyURI;
    }

    public URL getTermsOfServiceURI() {
        return this.tosURI;
    }

    public boolean supportsClaimsParam() {
        return this.claimsParamSupported;
    }

    public boolean supportsRequestParam() {
        return this.requestParamSupported;
    }

    public boolean supportsRequestURIParam() {
        return this.requestURIParamSupported;
    }

    public boolean requiresRequestURIRegistration() {
        return this.requireRequestURIReg;
    }

    public static OIDCProviderMetadata parse(JSONObject jsonObject) throws ParseException {
        String v3;
        int i$;
        String version = JSONObjectUtils.getString(jsonObject, "version");
        if (!version.equals(VERSION)) {
            throw new ParseException("The version must be \"3.0\"");
        }
        ArrayList<SubjectType> subjectTypes = new ArrayList<SubjectType>();
        for (String v2 : JSONObjectUtils.getStringArray(jsonObject, "subject_types_supported")) {
            subjectTypes.add(SubjectType.parse(v2));
        }
        Issuer issuer = new Issuer(JSONObjectUtils.getURL(jsonObject, "issuer").toString());
        OIDCProviderMetadata op = new OIDCProviderMetadata(issuer, Collections.unmodifiableList(subjectTypes));
        if (jsonObject.containsKey((Object)"authorization_endpoint")) {
            op.authzEndpoint = JSONObjectUtils.getURL(jsonObject, "authorization_endpoint");
        }
        if (jsonObject.containsKey((Object)"token_endpoint")) {
            op.tokenEndpoint = JSONObjectUtils.getURL(jsonObject, "token_endpoint");
        }
        if (jsonObject.containsKey((Object)"userinfo_endpoint")) {
            op.userInfoEndpoint = JSONObjectUtils.getURL(jsonObject, "userinfo_endpoint");
        }
        if (jsonObject.containsKey((Object)"registration_endpoint")) {
            op.regEndpoint = JSONObjectUtils.getURL(jsonObject, "registration_endpoint");
        }
        if (jsonObject.containsKey((Object)"check_session_iframe")) {
            op.checkSessionIframe = JSONObjectUtils.getURL(jsonObject, "check_session_iframe");
        }
        if (jsonObject.containsKey((Object)"end_session_endpoint")) {
            op.endSessionEndpoint = JSONObjectUtils.getURL(jsonObject, "end_session_endpoint");
        }
        if (jsonObject.containsKey((Object)"jwks_uri")) {
            op.jwkSetURI = JSONObjectUtils.getURL(jsonObject, "jwks_uri");
        }
        if (jsonObject.containsKey((Object)"scopes_supported")) {
            op.scope = new Scope();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "scopes_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.scope.add(new Scope.Value(v3));
            }
        }
        if (jsonObject.containsKey((Object)"response_types_supported")) {
            op.rts = new ArrayList<ResponseType>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "response_types_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.rts.add(ResponseType.parse(v3));
            }
        }
        if (jsonObject.containsKey((Object)"grant_types_supported")) {
            op.gts = new ArrayList<GrantType>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "grant_types_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.gts.add(new GrantType(v3));
            }
        }
        if (jsonObject.containsKey((Object)"acr_values_supported")) {
            op.acrValues = new ArrayList<ACR>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "acr_values_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.acrValues.add(new ACR(v3));
            }
        }
        if (jsonObject.containsKey((Object)"token_endpoint_auth_methods_supported")) {
            op.tokenEndpointAuthMethods = new ArrayList<ClientAuthenticationMethod>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "token_endpoint_auth_methods_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.tokenEndpointAuthMethods.add(new ClientAuthenticationMethod(v3));
            }
        }
        if (jsonObject.containsKey((Object)"token_endpoint_auth_signing_alg_values_supported")) {
            op.tokenEndpointJWSAlgs = new ArrayList<JWSAlgorithm>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "token_endpoint_auth_signing_alg_values_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.tokenEndpointJWSAlgs.add(new JWSAlgorithm(v3));
            }
        }
        if (jsonObject.containsKey((Object)"request_object_signing_alg_values_supported")) {
            op.requestObjectJWSAlgs = new ArrayList<JWSAlgorithm>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "request_object_signing_alg_values_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.requestObjectJWSAlgs.add(new JWSAlgorithm(v3));
            }
        }
        if (jsonObject.containsKey((Object)"request_object_encryption_alg_values_supported")) {
            op.requestObjectJWEAlgs = new ArrayList<JWEAlgorithm>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "request_object_encryption_alg_values_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.requestObjectJWEAlgs.add(new JWEAlgorithm(v3));
            }
        }
        if (jsonObject.containsKey((Object)"request_object_encryption_enc_values_supported")) {
            op.requestObjectJWEEncs = new ArrayList<EncryptionMethod>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "request_object_encryption_enc_values_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.requestObjectJWEEncs.add(new EncryptionMethod(v3));
            }
        }
        if (jsonObject.containsKey((Object)"id_token_signing_alg_values_supported")) {
            op.idTokenJWSAlgs = new ArrayList<JWSAlgorithm>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "id_token_signing_alg_values_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.idTokenJWSAlgs.add(new JWSAlgorithm(v3));
            }
        }
        if (jsonObject.containsKey((Object)"id_token_encryption_alg_values_supported")) {
            op.idTokenJWEAlgs = new ArrayList<JWEAlgorithm>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "id_token_encryption_alg_values_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.idTokenJWEAlgs.add(new JWEAlgorithm(v3));
            }
        }
        if (jsonObject.containsKey((Object)"id_token_encryption_enc_values_supported")) {
            op.idTokenJWEEncs = new ArrayList<EncryptionMethod>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "id_token_encryption_enc_values_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.idTokenJWEEncs.add(new EncryptionMethod(v3));
            }
        }
        if (jsonObject.containsKey((Object)"userinfo_signing_alg_values_supported")) {
            op.userInfoJWSAlgs = new ArrayList<JWSAlgorithm>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "userinfo_signing_alg_values_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.userInfoJWSAlgs.add(new JWSAlgorithm(v3));
            }
        }
        if (jsonObject.containsKey((Object)"userinfo_encryption_alg_values_supported")) {
            op.userInfoJWEAlgs = new ArrayList<JWEAlgorithm>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "userinfo_encryption_alg_values_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.userInfoJWEAlgs.add(new JWEAlgorithm(v3));
            }
        }
        if (jsonObject.containsKey((Object)"userinfo_encryption_enc_values_supported")) {
            op.userInfoJWEEncs = new ArrayList<EncryptionMethod>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "userinfo_encryption_enc_values_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.userInfoJWEEncs.add(new EncryptionMethod(v3));
            }
        }
        if (jsonObject.containsKey((Object)"display_values_supported")) {
            op.displays = new ArrayList<Display>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "display_values_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.displays.add(Display.parse(v3));
            }
        }
        if (jsonObject.containsKey((Object)"claim_types_supported")) {
            op.claimTypes = new ArrayList<ClaimType>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "claim_types_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.claimTypes.add(ClaimType.parse(v3));
            }
        }
        if (jsonObject.containsKey((Object)"claims_supported")) {
            op.claims = new ArrayList<String>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "claims_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                op.claims.add(v3);
            }
        }
        if (jsonObject.containsKey((Object)"claims_locales_supported")) {
            op.claimsLocales = new ArrayList<LangTag>();
            String[] arr$ = JSONObjectUtils.getStringArray(jsonObject, "claims_locales_supported");
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                v3 = arr$[i$];
                if (v3 == null) continue;
                try {
                    op.claimsLocales.add(LangTag.parse((String)v3));
                    continue;
                }
                catch (LangTagException e) {
                    throw new ParseException("Invalid claims_locales_supported field: " + e.getMessage(), e);
                }
            }
        }
        if (jsonObject.containsKey((Object)"ui_locales_supported")) {
            op.uiLocales = new ArrayList<LangTag>();
            for (String v3 : JSONObjectUtils.getStringArray(jsonObject, "ui_locales_supported")) {
                if (v3 == null) continue;
                try {
                    op.uiLocales.add(LangTag.parse((String)v3));
                }
                catch (LangTagException e) {
                    throw new ParseException("Invalid ui_locales_supported field: " + e.getMessage(), e);
                }
            }
        }
        if (jsonObject.containsKey((Object)"service_documentation")) {
            op.serviceDocsURL = JSONObjectUtils.getURL(jsonObject, "service_documentation");
        }
        if (jsonObject.containsKey((Object)"op_policy_uri")) {
            op.policyURI = JSONObjectUtils.getURL(jsonObject, "op_policy_uri");
        }
        if (jsonObject.containsKey((Object)"op_tos_uri")) {
            op.tosURI = JSONObjectUtils.getURL(jsonObject, "op_tos_uri");
        }
        if (jsonObject.containsKey((Object)"claims_parameter_supported")) {
            op.claimsParamSupported = JSONObjectUtils.getBoolean(jsonObject, "claims_parameter_supported");
        }
        if (jsonObject.containsKey((Object)"request_parameter_supported")) {
            op.requestParamSupported = JSONObjectUtils.getBoolean(jsonObject, "request_parameter_supported");
        }
        if (jsonObject.containsKey((Object)"request_uri_parameter_supported")) {
            op.requestURIParamSupported = JSONObjectUtils.getBoolean(jsonObject, "request_uri_parameter_supported");
        }
        if (jsonObject.containsKey((Object)"require_request_uri_registration")) {
            op.requireRequestURIReg = JSONObjectUtils.getBoolean(jsonObject, "require_request_uri_registration");
        }
        return op;
    }

    public static OIDCProviderMetadata parse(String s) throws ParseException {
        return OIDCProviderMetadata.parse(JSONObjectUtils.parseJSONObject(s));
    }
}

