/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.rp;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.rp.ApplicationType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class OIDCClientMetadata
extends ClientMetadata {
    private ApplicationType applicationType;
    private SubjectType subjectType;
    private URL sectorIDURI;
    private Set<URL> requestObjectURIs;
    private JWSAlgorithm requestObjectJWSAlg;
    private JWSAlgorithm idTokenJWSAlg;
    private JWEAlgorithm idTokenJWEAlg;
    private EncryptionMethod idTokenJWEEnc;
    private JWSAlgorithm userInfoJWSAlg;
    private JWEAlgorithm userInfoJWEAlg;
    private EncryptionMethod userInfoJWEEnc;
    private int defaultMaxAge;
    private boolean requiresAuthTime;
    private List<ACR> defaultACRs;
    private URL initiateLoginURI;
    private URL postLogoutRedirectURI;

    public OIDCClientMetadata() {
    }

    public OIDCClientMetadata(ClientMetadata metadata) {
        super(metadata);
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public URL getSectorIDURI() {
        return this.sectorIDURI;
    }

    public void setSectorIDURI(URL sectorIDURI) {
        this.sectorIDURI = sectorIDURI;
    }

    public Set<URL> getRequestObjectURIs() {
        return this.requestObjectURIs;
    }

    public void setRequestObjectURIs(Set<URL> requestObjectURIs) {
        this.requestObjectURIs = requestObjectURIs;
    }

    public JWSAlgorithm getRequestObjectJWSAlg() {
        return this.requestObjectJWSAlg;
    }

    public void setRequestObjectJWSAlg(JWSAlgorithm requestObjectJWSAlg) {
        this.requestObjectJWSAlg = requestObjectJWSAlg;
    }

    public JWSAlgorithm getIDTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public void setIDTokenJWSAlg(JWSAlgorithm idTokenJWSAlg) {
        this.idTokenJWSAlg = idTokenJWSAlg;
    }

    public JWEAlgorithm getIDTokenJWEAlg() {
        return this.idTokenJWEAlg;
    }

    public void setIDTokenJWEAlg(JWEAlgorithm idTokenJWEAlg) {
        this.idTokenJWEAlg = idTokenJWEAlg;
    }

    public EncryptionMethod getIDTokenJWEEnc() {
        return this.idTokenJWEEnc;
    }

    public void setIDTokenJWEEnc(EncryptionMethod idTokenJWEEnc) {
        this.idTokenJWEEnc = idTokenJWEEnc;
    }

    public JWSAlgorithm getUserInfoJWSAlg() {
        return this.userInfoJWSAlg;
    }

    public void setUserInfoJWSAlg(JWSAlgorithm userInfoJWSAlg) {
        this.userInfoJWSAlg = userInfoJWSAlg;
    }

    public JWEAlgorithm getUserInfoJWEAlg() {
        return this.userInfoJWEAlg;
    }

    public void setUserInfoJWEAlg(JWEAlgorithm userInfoJWEAlg) {
        this.userInfoJWEAlg = userInfoJWEAlg;
    }

    public EncryptionMethod getUserInfoJWEEnc() {
        return this.userInfoJWEEnc;
    }

    public void setUserInfoJWEEnc(EncryptionMethod userInfoJWEEnc) {
        this.userInfoJWEEnc = userInfoJWEEnc;
    }

    public int getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(int defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public boolean requiresAuthTime() {
        return this.requiresAuthTime;
    }

    public void requiresAuthTime(boolean requiresAuthTime) {
        this.requiresAuthTime = requiresAuthTime;
    }

    public List<ACR> getDefaultACRs() {
        return this.defaultACRs;
    }

    public void setDefaultACRs(List<ACR> defaultACRs) {
        this.defaultACRs = defaultACRs;
    }

    public URL getInitiateLoginURI() {
        return this.initiateLoginURI;
    }

    public void setInitiateLoginURI(URL loginURI) {
        this.initiateLoginURI = loginURI;
    }

    public URL getPostLogoutRedirectURI() {
        return this.postLogoutRedirectURI;
    }

    public void setPostLogoutRedirectURI(URL logoutURI) {
        this.postLogoutRedirectURI = logoutURI;
    }

    @Override
    public void applyDefaults() {
        super.applyDefaults();
        if (this.idTokenJWSAlg == null) {
            this.idTokenJWSAlg = JWSAlgorithm.RS256;
        }
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        if (this.applicationType != null) {
            o.put((Object)"application_type", (Object)this.applicationType.toString());
        }
        if (this.subjectType != null) {
            o.put((Object)"subject_type", (Object)this.subjectType.toString());
        }
        if (this.sectorIDURI != null) {
            o.put((Object)"sector_identifier_uri", (Object)this.sectorIDURI.toString());
        }
        if (this.requestObjectURIs != null) {
            JSONArray uriList = new JSONArray();
            for (URL uri : this.requestObjectURIs) {
                uriList.add((Object)uri.toString());
            }
            o.put((Object)"request_uris", (Object)uriList);
        }
        if (this.requestObjectJWSAlg != null) {
            o.put((Object)"request_object_signing_alg", (Object)this.requestObjectJWSAlg.getName());
        }
        if (this.idTokenJWSAlg != null) {
            o.put((Object)"id_token_signed_response_alg", (Object)this.idTokenJWSAlg.getName());
        }
        if (this.idTokenJWEAlg != null) {
            o.put((Object)"id_token_encrypted_response_alg", (Object)this.idTokenJWEAlg.getName());
        }
        if (this.idTokenJWEEnc != null) {
            o.put((Object)"id_token_encrypted_response_enc", (Object)this.idTokenJWEEnc.getName());
        }
        if (this.userInfoJWSAlg != null) {
            o.put((Object)"userinfo_signed_response_alg", (Object)this.userInfoJWSAlg.getName());
        }
        if (this.userInfoJWEAlg != null) {
            o.put((Object)"userinfo_encrypted_response_alg", (Object)this.userInfoJWEAlg.getName());
        }
        if (this.userInfoJWEEnc != null) {
            o.put((Object)"userinfo_encrypted_response_enc", (Object)this.userInfoJWEEnc.getName());
        }
        if (this.defaultMaxAge > 0) {
            o.put((Object)"default_max_age", (Object)this.defaultMaxAge);
        }
        o.put((Object)"require_auth_time", (Object)this.requiresAuthTime);
        if (this.defaultACRs != null) {
            JSONArray acrList = new JSONArray();
            for (ACR acr : this.defaultACRs) {
                acrList.add((Object)acr);
            }
            o.put((Object)"default_acr_values", (Object)acrList);
        }
        if (this.initiateLoginURI != null) {
            o.put((Object)"initiate_login_uri", (Object)this.initiateLoginURI.toString());
        }
        if (this.postLogoutRedirectURI != null) {
            o.put((Object)"post_logout_redirect_uri", (Object)this.postLogoutRedirectURI.toString());
        }
        return o;
    }

    public static OIDCClientMetadata parse(JSONObject jsonObject) throws ParseException {
        ClientMetadata baseMetadata = ClientMetadata.parse(jsonObject);
        OIDCClientMetadata metadata = new OIDCClientMetadata(baseMetadata);
        if (jsonObject.containsKey((Object)"application_type")) {
            metadata.setApplicationType(JSONObjectUtils.getEnum(jsonObject, "application_type", ApplicationType.class));
        }
        if (jsonObject.containsKey((Object)"subject_type")) {
            metadata.setSubjectType(JSONObjectUtils.getEnum(jsonObject, "subject_type", SubjectType.class));
        }
        if (jsonObject.containsKey((Object)"sector_identifier_uri")) {
            metadata.setSectorIDURI(JSONObjectUtils.getURL(jsonObject, "sector_identifier_uri"));
        }
        if (jsonObject.containsKey((Object)"request_uris")) {
            LinkedHashSet<URL> requestURIs = new LinkedHashSet<URL>();
            for (String uriString : JSONObjectUtils.getStringArray(jsonObject, "request_uris")) {
                try {
                    requestURIs.add(new URL(uriString));
                }
                catch (MalformedURLException e) {
                    throw new ParseException("Invalid \"request_uris\" parameter");
                }
            }
            metadata.setRequestObjectURIs(requestURIs);
        }
        if (jsonObject.containsKey((Object)"request_object_signing_alg")) {
            metadata.setRequestObjectJWSAlg(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "request_object_signing_alg")));
        }
        if (jsonObject.containsKey((Object)"id_token_signed_response_alg")) {
            metadata.setIDTokenJWSAlg(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "id_token_signed_response_alg")));
        }
        if (jsonObject.containsKey((Object)"id_token_encrypted_response_alg")) {
            metadata.setIDTokenJWEAlg(new JWEAlgorithm(JSONObjectUtils.getString(jsonObject, "id_token_encrypted_response_alg")));
        }
        if (jsonObject.containsKey((Object)"id_token_encrypted_response_enc")) {
            metadata.setIDTokenJWEEnc(new EncryptionMethod(JSONObjectUtils.getString(jsonObject, "id_token_encrypted_response_enc")));
        }
        if (jsonObject.containsKey((Object)"userinfo_signed_response_alg")) {
            metadata.setUserInfoJWSAlg(new JWSAlgorithm(JSONObjectUtils.getString(jsonObject, "userinfo_signed_response_alg")));
        }
        if (jsonObject.containsKey((Object)"userinfo_encrypted_response_alg")) {
            metadata.setUserInfoJWEAlg(new JWEAlgorithm(JSONObjectUtils.getString(jsonObject, "userinfo_encrypted_response_alg")));
        }
        if (jsonObject.containsKey((Object)"userinfo_encrypted_response_enc")) {
            metadata.setUserInfoJWEEnc(new EncryptionMethod(JSONObjectUtils.getString(jsonObject, "userinfo_encrypted_response_enc")));
        }
        if (jsonObject.containsKey((Object)"default_max_age")) {
            metadata.setDefaultMaxAge(JSONObjectUtils.getInt(jsonObject, "default_max_age"));
        }
        if (jsonObject.containsKey((Object)"require_auth_time")) {
            metadata.requiresAuthTime(JSONObjectUtils.getBoolean(jsonObject, "require_auth_time"));
        }
        if (jsonObject.containsKey((Object)"default_acr_values")) {
            LinkedList<ACR> acrValues = new LinkedList<ACR>();
            for (String acrString : JSONObjectUtils.getStringArray(jsonObject, "default_acr_values")) {
                acrValues.add(new ACR(acrString));
            }
            metadata.setDefaultACRs(acrValues);
        }
        if (jsonObject.containsKey((Object)"initiate_login_uri")) {
            metadata.setInitiateLoginURI(JSONObjectUtils.getURL(jsonObject, "initiate_login_uri"));
        }
        if (jsonObject.containsKey((Object)"post_logout_redirect_uri")) {
            metadata.setPostLogoutRedirectURI(JSONObjectUtils.getURL(jsonObject, "post_logout_redirect_uri"));
        }
        return metadata;
    }
}

