/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.util;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeaderFilter;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeaderFilter;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.openid.connect.sdk.util.JWTDecoder;
import java.text.ParseException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWTDecoder
implements JWTDecoder {
    private final Map<JWSAlgorithm, JWSVerifier> jwsVerifiers = new Hashtable<JWSAlgorithm, JWSVerifier>();
    private final Map<JWEAlgorithm, JWEDecrypter> jweDecrypters = new Hashtable<JWEAlgorithm, JWEDecrypter>();

    public void addJWSVerifier(JWSVerifier verifier) {
        JWSHeaderFilter filter = verifier.getJWSHeaderFilter();
        for (JWSAlgorithm alg : filter.getAcceptedAlgorithms()) {
            this.jwsVerifiers.put(alg, verifier);
        }
    }

    public Collection<JWSVerifier> getJWSVerifiers() {
        return this.jwsVerifiers.values();
    }

    public void addJWEDecrypter(JWEDecrypter decrypter) {
        JWEHeaderFilter filter = decrypter.getJWEHeaderFilter();
        for (JWEAlgorithm alg : filter.getAcceptedAlgorithms()) {
            this.jweDecrypters.put(alg, decrypter);
        }
    }

    public Collection<JWEDecrypter> getJWEDecrypters() {
        return this.jweDecrypters.values();
    }

    private ReadOnlyJWTClaimsSet verify(SignedJWT signedJWT) throws JOSEException, ParseException {
        JWSAlgorithm alg = signedJWT.getHeader().getAlgorithm();
        JWSVerifier verifier = this.jwsVerifiers.get(alg);
        if (verifier == null) {
            throw new JOSEException("Unsupported JWS algorithm: " + alg);
        }
        boolean verified = false;
        try {
            verified = signedJWT.verify(verifier);
        }
        catch (IllegalStateException e) {
            throw new JOSEException(e.getMessage(), (Throwable)e);
        }
        if (!verified) {
            throw new JOSEException("Bad JWS signature");
        }
        return signedJWT.getJWTClaimsSet();
    }

    private ReadOnlyJWTClaimsSet decrypt(EncryptedJWT encryptedJWT) throws JOSEException, ParseException {
        JWEAlgorithm alg = encryptedJWT.getHeader().getAlgorithm();
        JWEDecrypter decrypter = this.jweDecrypters.get(alg);
        if (decrypter == null) {
            throw new JOSEException("Unsupported JWE algorithm: " + alg);
        }
        try {
            encryptedJWT.decrypt(decrypter);
        }
        catch (IllegalStateException e) {
            throw new JOSEException(e.getMessage(), (Throwable)e);
        }
        return encryptedJWT.getJWTClaimsSet();
    }

    @Override
    public ReadOnlyJWTClaimsSet decodeJWT(JWT jwt) throws JOSEException, ParseException {
        if (jwt instanceof PlainJWT) {
            PlainJWT plainJWT = (PlainJWT)jwt;
            return plainJWT.getJWTClaimsSet();
        }
        if (jwt instanceof SignedJWT) {
            SignedJWT signedJWT = (SignedJWT)jwt;
            return this.verify(signedJWT);
        }
        if (jwt instanceof EncryptedJWT) {
            EncryptedJWT encryptedJWT = (EncryptedJWT)jwt;
            return this.decrypt(encryptedJWT);
        }
        throw new JOSEException("Unexpected JWT type: " + jwt.getClass());
    }
}

