/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class OIDCAccessTokenResponse
extends AccessTokenResponse
implements OIDCTokenResponse {
    private final JWT idToken;

    public OIDCAccessTokenResponse(AccessToken accessToken, RefreshToken refreshToken, JWT idToken) {
        super(accessToken, refreshToken);
        this.idToken = idToken;
    }

    public JWT getIDToken() {
        return this.idToken;
    }

    @Override
    public JSONObject toJSONObject() throws SerializeException {
        JSONObject o = super.toJSONObject();
        if (this.idToken != null) {
            try {
                o.put((Object)"id_token", (Object)this.idToken.serialize());
            }
            catch (IllegalStateException e) {
                throw new SerializeException("Couldn't serialize ID token: " + e.getMessage(), e);
            }
        }
        return o;
    }

    public static OIDCAccessTokenResponse parse(JSONObject jsonObject) throws ParseException {
        AccessTokenResponse atr = AccessTokenResponse.parse(jsonObject);
        JWT idToken = null;
        if (jsonObject.containsKey((Object)"id_token")) {
            try {
                idToken = JWTParser.parse((String)JSONObjectUtils.getString(jsonObject, "id_token"));
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Couldn't parse ID token: " + e.getMessage(), e);
            }
        }
        return new OIDCAccessTokenResponse(atr.getAccessToken(), atr.getRefreshToken(), idToken);
    }

    public static OIDCAccessTokenResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return OIDCAccessTokenResponse.parse(jsonObject);
    }
}

