/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.claims;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagUtils;
import com.nimbusds.oauth2.sdk.util.DateUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public abstract class ClaimsSet {
    private final JSONObject claims;

    protected ClaimsSet() {
        this.claims = new JSONObject();
    }

    protected ClaimsSet(JSONObject jsonObject) {
        if (jsonObject == null) {
            throw new IllegalArgumentException("The JSON object must not be null");
        }
        this.claims = jsonObject;
    }

    public Object getClaim(String name) {
        return this.claims.get((Object)name);
    }

    public <T> T getClaim(String name, Class<T> clazz) {
        try {
            return (T)this.claims.get((Object)name);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public <T> Map<LangTag, T> getLangTaggedClaim(String name, Class<T> clazz) {
        Map matches = LangTagUtils.find((String)name, (Map)this.claims);
        HashMap out = new HashMap();
        for (Map.Entry entry : matches.entrySet()) {
            try {
                out.put(entry.getKey(), entry.getValue());
            }
            catch (ClassCastException e) {}
        }
        return out;
    }

    public void setClaim(String name, Object value) {
        if (value != null) {
            this.claims.put((Object)name, value);
        } else {
            this.claims.remove((Object)name);
        }
    }

    public <T> void setClaim(String name, Object value, LangTag langTag) {
        String keyName = langTag != null ? name + "#" + langTag : name;
        this.setClaim(keyName, value);
    }

    public String getStringClaim(String name) {
        return this.getClaim(name, String.class);
    }

    public String getStringClaim(String name, LangTag langTag) {
        if (langTag == null) {
            return this.getStringClaim(name);
        }
        return this.getStringClaim(name + '#' + langTag);
    }

    public Boolean getBooleanClaim(String name) {
        return this.getClaim(name, Boolean.class);
    }

    public Number getNumberClaim(String name) {
        return this.getClaim(name, Number.class);
    }

    public URL getURLClaim(String name) {
        String value = this.getStringClaim(name);
        if (value == null) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void setURLClaim(String name, URL value) {
        if (value != null) {
            this.setClaim(name, value.toString());
        } else {
            this.claims.remove((Object)name);
        }
    }

    public InternetAddress getEmailClaim(String name) {
        String value = this.getStringClaim(name);
        if (value == null) {
            return null;
        }
        try {
            return new InternetAddress(value);
        }
        catch (AddressException e) {
            return null;
        }
    }

    public void setEmailClaim(String name, InternetAddress value) {
        if (value != null) {
            this.setClaim(name, value.getAddress());
        } else {
            this.claims.remove((Object)name);
        }
    }

    public Date getDateClaim(String name) {
        Number value = this.getNumberClaim(name);
        if (value == null) {
            return null;
        }
        try {
            return DateUtils.fromSecondsSinceEpoch(value.longValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setDateClaim(String name, Date value) {
        if (value != null) {
            this.setClaim(name, DateUtils.toSecondsSinceEpoch(value));
        } else {
            this.claims.remove((Object)name);
        }
    }

    public List<String> getStringListClaim(String name) {
        List rawList = this.getClaim(name, List.class);
        if (rawList == null) {
            rawList = (List)this.getClaim(name, JSONArray.class);
        }
        if (rawList == null) {
            return null;
        }
        ArrayList<String> outputList = new ArrayList<String>(rawList.size());
        for (Object item : rawList) {
            if (item == null) continue;
            outputList.add(item.toString());
        }
        return outputList;
    }

    public JSONObject toJSONObject() {
        return this.claims;
    }

    public JWTClaimsSet toJWTClaimsSet() throws ParseException {
        return JWTClaimsSet.parse((JSONObject)this.claims);
    }
}

