/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.claims;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.claims.Address;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.Gender;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import net.minidev.json.JSONObject;

public class UserInfo
extends ClaimsSet {
    public static final String SUB_CLAIM_NAME = "sub";
    public static final String NAME_CLAIM_NAME = "name";
    public static final String GIVEN_NAME_CLAIM_NAME = "given_name";
    public static final String FAMILY_NAME_CLAIM_NAME = "family_name";
    public static final String MIDDLE_NAME_CLAIM_NAME = "middle_name";
    public static final String NICKNAME_CLAIM_NAME = "nickname";
    public static final String PREFERRED_USERNAME_CLAIM_NAME = "preferred_username";
    public static final String PROFILE_CLAIM_NAME = "profile";
    public static final String PICTURE_CLAIM_NAME = "picture";
    public static final String WEBSITE_CLAIM_NAME = "website";
    public static final String EMAIL_CLAIM_NAME = "email";
    public static final String EMAIL_VERIFIED_CLAIM_NAME = "email_verified";
    public static final String GENDER_CLAIM_NAME = "gender";
    public static final String BIRTHDATE_CLAIM_NAME = "birthdate";
    public static final String ZONEINFO_CLAIM_NAME = "zoneinfo";
    public static final String LOCALE_CLAIM_NAME = "locale";
    public static final String PHONE_NUMBER_CLAIM_NAME = "phone_number";
    public static final String PHONE_NUMBER_VERIFIED_CLAIM_NAME = "phone_number_verified";
    public static final String ADDRESS_CLAIM_NAME = "address";
    public static final String UPDATED_AT_CLAIM_NAME = "updated_at";
    private static final Set<String> stdClaimNames = new LinkedHashSet<String>();

    public static Set<String> getStandardClaimNames() {
        return Collections.unmodifiableSet(stdClaimNames);
    }

    public UserInfo(Subject sub) {
        this.setClaim(SUB_CLAIM_NAME, sub.getValue());
    }

    public UserInfo(JSONObject jsonObject) {
        super(jsonObject);
        if (this.getStringClaim(SUB_CLAIM_NAME) == null) {
            throw new IllegalArgumentException("Missing or invalid \"sub\" claim");
        }
    }

    public UserInfo(JWTClaimsSet jwtClaimsSet) {
        this(jwtClaimsSet.toJSONObject());
    }

    public Subject getSubject() {
        return new Subject(this.getStringClaim(SUB_CLAIM_NAME));
    }

    public String getName() {
        return this.getStringClaim(NAME_CLAIM_NAME);
    }

    public String getName(LangTag langTag) {
        return this.getStringClaim(NAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getNameEntries() {
        return this.getLangTaggedClaim(NAME_CLAIM_NAME, String.class);
    }

    public void setName(String name) {
        this.setClaim(NAME_CLAIM_NAME, name);
    }

    public void setName(String name, LangTag langTag) {
        this.setClaim(NAME_CLAIM_NAME, name, langTag);
    }

    public String getGivenName() {
        return this.getStringClaim(GIVEN_NAME_CLAIM_NAME);
    }

    public String getGivenName(LangTag langTag) {
        return this.getStringClaim(GIVEN_NAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getGivenNameEntries() {
        return this.getLangTaggedClaim(GIVEN_NAME_CLAIM_NAME, String.class);
    }

    public void setGivenName(String givenName) {
        this.setClaim(GIVEN_NAME_CLAIM_NAME, givenName);
    }

    public void setGivenName(String givenName, LangTag langTag) {
        this.setClaim(GIVEN_NAME_CLAIM_NAME, givenName, langTag);
    }

    public String getFamilyName() {
        return this.getStringClaim(FAMILY_NAME_CLAIM_NAME);
    }

    public String getFamilyName(LangTag langTag) {
        return this.getStringClaim(FAMILY_NAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getFamilyNameEntries() {
        return this.getLangTaggedClaim(FAMILY_NAME_CLAIM_NAME, String.class);
    }

    public void setFamilyName(String familyName) {
        this.setClaim(FAMILY_NAME_CLAIM_NAME, familyName);
    }

    public void setFamilyName(String familyName, LangTag langTag) {
        this.setClaim(FAMILY_NAME_CLAIM_NAME, familyName, langTag);
    }

    public String getMiddleName() {
        return this.getStringClaim(MIDDLE_NAME_CLAIM_NAME);
    }

    public String getMiddleName(LangTag langTag) {
        return this.getStringClaim(MIDDLE_NAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getMiddleNameEntries() {
        return this.getLangTaggedClaim(MIDDLE_NAME_CLAIM_NAME, String.class);
    }

    public void setMiddleName(String middleName) {
        this.setClaim(MIDDLE_NAME_CLAIM_NAME, middleName);
    }

    public void setMiddleName(String middleName, LangTag langTag) {
        this.setClaim(MIDDLE_NAME_CLAIM_NAME, middleName, langTag);
    }

    public String getNickname() {
        return this.getStringClaim(NICKNAME_CLAIM_NAME);
    }

    public String getNickname(LangTag langTag) {
        return this.getStringClaim(NICKNAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getNicknameEntries() {
        return this.getLangTaggedClaim(NICKNAME_CLAIM_NAME, String.class);
    }

    public void setNickname(String nickname) {
        this.setClaim(NICKNAME_CLAIM_NAME, nickname);
    }

    public void setNickname(String nickname, LangTag langTag) {
        this.setClaim(NICKNAME_CLAIM_NAME, nickname, langTag);
    }

    public String getPreferredUsername() {
        return this.getStringClaim(PREFERRED_USERNAME_CLAIM_NAME);
    }

    public void setPreferredUsername(String preferredUsername) {
        this.setClaim(PREFERRED_USERNAME_CLAIM_NAME, preferredUsername);
    }

    public URL getProfile() {
        return this.getURLClaim(PROFILE_CLAIM_NAME);
    }

    public void setProfile(URL profile) {
        this.setURLClaim(PROFILE_CLAIM_NAME, profile);
    }

    public URL getPicture() {
        return this.getURLClaim(PICTURE_CLAIM_NAME);
    }

    public void setPicture(URL picture) {
        this.setURLClaim(PICTURE_CLAIM_NAME, picture);
    }

    public URL getWebsite() {
        return this.getURLClaim(WEBSITE_CLAIM_NAME);
    }

    public void setWebsite(URL website) {
        this.setURLClaim(WEBSITE_CLAIM_NAME, website);
    }

    public InternetAddress getEmail() {
        return this.getEmailClaim(EMAIL_CLAIM_NAME);
    }

    public void setEmail(InternetAddress email) {
        this.setEmailClaim(EMAIL_CLAIM_NAME, email);
    }

    public Boolean getEmailVerified() {
        return this.getBooleanClaim(EMAIL_VERIFIED_CLAIM_NAME);
    }

    public void setEmailVerified(Boolean emailVerified) {
        this.setClaim(EMAIL_VERIFIED_CLAIM_NAME, emailVerified);
    }

    public Gender getGender() {
        String value = this.getStringClaim(GENDER_CLAIM_NAME);
        if (value == null) {
            return null;
        }
        return new Gender(value);
    }

    public void setGender(Gender gender) {
        if (gender != null) {
            this.setClaim(GENDER_CLAIM_NAME, gender.getValue());
        } else {
            this.setClaim(GENDER_CLAIM_NAME, null);
        }
    }

    public String getBirthdate() {
        return this.getStringClaim(BIRTHDATE_CLAIM_NAME);
    }

    public void setBirthdate(String birthdate) {
        this.setClaim(BIRTHDATE_CLAIM_NAME, birthdate);
    }

    public String getZoneinfo() {
        return this.getStringClaim(ZONEINFO_CLAIM_NAME);
    }

    public void setZoneinfo(String zoneinfo) {
        this.setClaim(ZONEINFO_CLAIM_NAME, zoneinfo);
    }

    public String getLocale() {
        return this.getStringClaim(LOCALE_CLAIM_NAME);
    }

    public void setLocale(String locale) {
        this.setClaim(LOCALE_CLAIM_NAME, locale);
    }

    public String getPhoneNumber() {
        return this.getStringClaim(PHONE_NUMBER_CLAIM_NAME);
    }

    public void setPhoneNumber(String phoneNumber) {
        this.setClaim(PHONE_NUMBER_CLAIM_NAME, phoneNumber);
    }

    public Boolean getPhoneNumberVerified() {
        return this.getBooleanClaim(PHONE_NUMBER_VERIFIED_CLAIM_NAME);
    }

    public void setPhoneNumberVerified(Boolean phoneNumberVerified) {
        this.setClaim(PHONE_NUMBER_VERIFIED_CLAIM_NAME, phoneNumberVerified);
    }

    public Address getAddress() {
        return this.getAddress(null);
    }

    public Address getAddress(LangTag langTag) {
        String name = langTag != null ? "address#" + langTag : ADDRESS_CLAIM_NAME;
        JSONObject jsonObject = this.getClaim(name, JSONObject.class);
        if (jsonObject == null) {
            return null;
        }
        return new Address(jsonObject);
    }

    public Map<LangTag, Address> getAddressEntries() {
        Map<LangTag, JSONObject> entriesIn = this.getLangTaggedClaim(ADDRESS_CLAIM_NAME, JSONObject.class);
        HashMap<LangTag, Address> entriesOut = new HashMap<LangTag, Address>();
        for (Map.Entry<LangTag, JSONObject> en : entriesIn.entrySet()) {
            entriesOut.put(en.getKey(), new Address(en.getValue()));
        }
        return entriesOut;
    }

    public void setAddress(Address address) {
        if (address != null) {
            this.setClaim(ADDRESS_CLAIM_NAME, address.toJSONObject());
        } else {
            this.setClaim(ADDRESS_CLAIM_NAME, null);
        }
    }

    public void setAddress(Address address, LangTag langTag) {
        String key;
        String string = key = langTag == null ? ADDRESS_CLAIM_NAME : "address#" + langTag;
        if (address != null) {
            this.setClaim(key, address.toJSONObject());
        } else {
            this.setClaim(key, null);
        }
    }

    public Date getUpdatedTime() {
        return this.getDateClaim(UPDATED_AT_CLAIM_NAME);
    }

    public void setUpdatedTime(Date updatedTime) {
        this.setDateClaim(UPDATED_AT_CLAIM_NAME, updatedTime);
    }

    public static UserInfo parse(String json) throws ParseException {
        JSONObject jsonObject = JSONObjectUtils.parseJSONObject(json);
        try {
            return new UserInfo(jsonObject);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }

    static {
        stdClaimNames.add(SUB_CLAIM_NAME);
        stdClaimNames.add(NAME_CLAIM_NAME);
        stdClaimNames.add(GIVEN_NAME_CLAIM_NAME);
        stdClaimNames.add(FAMILY_NAME_CLAIM_NAME);
        stdClaimNames.add(MIDDLE_NAME_CLAIM_NAME);
        stdClaimNames.add(NICKNAME_CLAIM_NAME);
        stdClaimNames.add(PREFERRED_USERNAME_CLAIM_NAME);
        stdClaimNames.add(PROFILE_CLAIM_NAME);
        stdClaimNames.add(PICTURE_CLAIM_NAME);
        stdClaimNames.add(WEBSITE_CLAIM_NAME);
        stdClaimNames.add(EMAIL_CLAIM_NAME);
        stdClaimNames.add(EMAIL_VERIFIED_CLAIM_NAME);
        stdClaimNames.add(GENDER_CLAIM_NAME);
        stdClaimNames.add(BIRTHDATE_CLAIM_NAME);
        stdClaimNames.add(ZONEINFO_CLAIM_NAME);
        stdClaimNames.add(LOCALE_CLAIM_NAME);
        stdClaimNames.add(PHONE_NUMBER_CLAIM_NAME);
        stdClaimNames.add(PHONE_NUMBER_VERIFIED_CLAIM_NAME);
        stdClaimNames.add(ADDRESS_CLAIM_NAME);
        stdClaimNames.add(UPDATED_AT_CLAIM_NAME);
    }
}

