/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.rp;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.client.ClientInformation;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class OIDCClientInformation
extends ClientInformation {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;

    public OIDCClientInformation(ClientID id, Date issueDate, OIDCClientMetadata metadata, Secret secret) {
        this(id, issueDate, metadata, secret, null, null);
    }

    public OIDCClientInformation(ClientID id, Date issueDate, OIDCClientMetadata metadata, Secret secret, URI registrationURI, BearerAccessToken accessToken) {
        super(id, issueDate, metadata, secret, registrationURI, accessToken);
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public OIDCClientMetadata getOIDCClientMetadata() {
        return (OIDCClientMetadata)this.getClientMetadata();
    }

    public static OIDCClientInformation parse(JSONObject jsonObject) throws ParseException {
        ClientID id = new ClientID(JSONObjectUtils.getString(jsonObject, "client_id"));
        Date issueDate = null;
        if (jsonObject.containsKey((Object)"client_id_issued_at")) {
            issueDate = new Date(JSONObjectUtils.getLong(jsonObject, "client_id_issued_at") * 1000L);
        }
        OIDCClientMetadata metadata = OIDCClientMetadata.parse(jsonObject);
        Secret secret = null;
        if (jsonObject.containsKey((Object)"client_secret")) {
            String value = JSONObjectUtils.getString(jsonObject, "client_secret");
            Date exp = null;
            if (jsonObject.containsKey((Object)"client_secret_expires_at")) {
                exp = new Date(JSONObjectUtils.getLong(jsonObject, "client_secret_expires_at") * 1000L);
            }
            secret = new Secret(value, exp);
        }
        URI registrationURI = null;
        if (jsonObject.containsKey((Object)"registration_client_uri")) {
            registrationURI = JSONObjectUtils.getURI(jsonObject, "registration_client_uri");
        }
        BearerAccessToken accessToken = null;
        if (jsonObject.containsKey((Object)"registration_access_token")) {
            accessToken = new BearerAccessToken(JSONObjectUtils.getString(jsonObject, "registration_access_token"));
        }
        return new OIDCClientInformation(id, issueDate, metadata, secret, registrationURI, accessToken);
    }

    static {
        HashSet<String> p = new HashSet<String>(ClientInformation.getRegisteredParameterNames());
        p.addAll(OIDCClientMetadata.getRegisteredParameterNames());
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
    }
}

