/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.Secret;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class ResourceOwnerPasswordCredentialsGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.PASSWORD;
    private final String username;
    private final Secret password;
    private final Scope scope;

    public ResourceOwnerPasswordCredentialsGrant(String username, Secret password, Scope scope) {
        super(GRANT_TYPE);
        if (username == null) {
            throw new IllegalArgumentException("The username must not be null");
        }
        this.username = username;
        if (password == null) {
            throw new IllegalArgumentException("The password must not be null");
        }
        this.password = password;
        this.scope = scope;
    }

    public String getUsername() {
        return this.username;
    }

    public Secret getPassword() {
        return this.password;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public Map<String, String> toParameters() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", GRANT_TYPE.getValue());
        params.put("username", this.username);
        params.put("password", this.password.getValue());
        if (this.scope != null) {
            params.put("scope", this.scope.toString());
        }
        return params;
    }

    public static ResourceOwnerPasswordCredentialsGrant parse(Map<String, String> params) throws ParseException {
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            throw new ParseException("Missing \"grant_type\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        GrantType grantType = new GrantType(grantTypeString);
        if (!grantType.equals(GRANT_TYPE)) {
            throw new ParseException("The \"grant_type\" must be " + GRANT_TYPE, OAuth2Error.INVALID_GRANT);
        }
        String username = params.get("username");
        if (username == null || username.trim().isEmpty()) {
            throw new ParseException("Missing or empty \"username\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        String passwordString = params.get("password");
        if (passwordString == null || passwordString.trim().isEmpty()) {
            throw new ParseException("Missing or empty \"password\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        Secret password = new Secret(passwordString);
        String scopeValue = params.get("scope");
        Scope scope = null;
        if (scopeValue != null) {
            scope = Scope.parse(scopeValue);
        }
        return new ResourceOwnerPasswordCredentialsGrant(username, password, scope);
    }
}

