/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.http;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPMessage;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;

@ThreadSafe
public class HTTPResponse
extends HTTPMessage {
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_FOUND = 302;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_SERVER_ERROR = 500;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    private final int statusCode;
    private URI location = null;
    private String cacheControl = null;
    private String pragma = null;
    private String wwwAuthenticate = null;
    private String content = null;

    public HTTPResponse(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean indicatesSuccess() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public void ensureStatusCode(int ... expectedStatusCode) throws ParseException {
        for (int c : expectedStatusCode) {
            if (this.statusCode != c) continue;
            return;
        }
        throw new ParseException("Unexpected HTTP status code " + this.statusCode + ", must be " + Arrays.toString(expectedStatusCode));
    }

    public void ensureStatusCodeNotOK() throws ParseException {
        if (this.statusCode == 200) {
            throw new ParseException("Unexpected HTTP status code, must not be 200 (OK)");
        }
    }

    public URI getLocation() {
        return this.location;
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public void setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
    }

    public String getPragma() {
        return this.pragma;
    }

    public void setPragma(String pragma) {
        this.pragma = pragma;
    }

    public String getWWWAuthenticate() {
        return this.wwwAuthenticate;
    }

    public void setWWWAuthenticate(String wwwAuthenticate) {
        this.wwwAuthenticate = wwwAuthenticate;
    }

    private void ensureContent() throws ParseException {
        if (this.content == null || this.content.isEmpty()) {
            throw new ParseException("Missing or empty HTTP response body");
        }
    }

    public String getContent() {
        return this.content;
    }

    public JSONObject getContentAsJSONObject() throws ParseException {
        this.ensureContentType(CommonContentTypes.APPLICATION_JSON);
        this.ensureContent();
        return JSONObjectUtils.parseJSONObject(this.content);
    }

    public JWT getContentAsJWT() throws ParseException {
        this.ensureContentType(CommonContentTypes.APPLICATION_JWT);
        this.ensureContent();
        try {
            return JWTParser.parse((String)this.content);
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void applyTo(HttpServletResponse sr) throws IOException {
        sr.setStatus(this.statusCode);
        if (this.location != null) {
            sr.setHeader("Location", this.location.toString());
        }
        if (this.getContentType() != null) {
            sr.setContentType(this.getContentType().toString());
        }
        if (this.cacheControl != null) {
            sr.setHeader("Cache-Control", this.cacheControl);
        }
        if (this.pragma != null) {
            sr.setHeader("Pragma", this.pragma);
        }
        if (this.wwwAuthenticate != null) {
            sr.setHeader("Www-Authenticate", this.wwwAuthenticate);
        }
        if (this.content != null) {
            PrintWriter writer = sr.getWriter();
            writer.print(this.content);
            writer.close();
        }
    }
}

