/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class AuthorizationErrorResponse
extends AuthorizationResponse
implements ErrorResponse {
    private static final Set<ErrorObject> stdErrors = new HashSet<ErrorObject>();
    private final ErrorObject error;
    private final ResponseType rt;

    public static Set<ErrorObject> getStandardErrors() {
        return Collections.unmodifiableSet(stdErrors);
    }

    public AuthorizationErrorResponse(URI redirectURI, ErrorObject error, ResponseType rt, State state) {
        super(redirectURI, state);
        if (error == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = error;
        this.rt = rt;
    }

    public AuthorizationErrorResponse(URI redirectURI, ErrorObject error, State state) {
        this(redirectURI, error, null, state);
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    public ResponseType getResponseType() {
        return this.rt;
    }

    @Override
    public Map<String, String> toParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("error", this.error.getCode());
        if (this.error.getDescription() != null) {
            params.put("error_description", this.error.getDescription());
        }
        if (this.error.getURI() != null) {
            params.put("error_uri", this.error.getURI().toString());
        }
        if (this.getState() != null) {
            params.put("state", this.getState().getValue());
        }
        return params;
    }

    @Override
    public URI toURI() throws SerializeException {
        StringBuilder sb = new StringBuilder(this.getRedirectionURI().toString());
        if (this.rt == null || this.rt.contains(ResponseType.Value.TOKEN)) {
            sb.append("#");
        } else {
            sb.append("?");
        }
        sb.append(URLUtils.serializeParameters(this.toParameters()));
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new SerializeException("Couldn't serialize redirection URI: " + e.getMessage(), e);
        }
    }

    public static AuthorizationErrorResponse parse(URI redirectURI, Map<String, String> params) throws ParseException {
        if (StringUtils.isBlank((CharSequence)params.get("error"))) {
            throw new ParseException("Missing error code");
        }
        String errorCode = params.get("error");
        String errorDescription = params.get("error_description");
        String errorURIString = params.get("error_uri");
        URI errorURI = null;
        if (errorURIString != null) {
            try {
                errorURI = new URI(errorURIString);
            }
            catch (URISyntaxException e) {
                throw new ParseException("Invalid error URI: " + errorURIString, e);
            }
        }
        ErrorObject error = new ErrorObject(errorCode, errorDescription, 302, errorURI);
        State state = State.parse(params.get("state"));
        return new AuthorizationErrorResponse(redirectURI, error, null, state);
    }

    public static AuthorizationErrorResponse parse(URI uri) throws ParseException {
        Map<String, String> params;
        if (uri.getRawFragment() != null) {
            params = URLUtils.parseParameters(uri.getRawFragment());
        } else if (uri.getRawQuery() != null) {
            params = URLUtils.parseParameters(uri.getRawQuery());
        } else {
            throw new ParseException("Missing URI fragment or query string");
        }
        return AuthorizationErrorResponse.parse(URIUtils.getBaseURI(uri), params);
    }

    public static AuthorizationErrorResponse parse(HTTPResponse httpResponse) throws ParseException {
        if (httpResponse.getStatusCode() != 302) {
            throw new ParseException("Unexpected HTTP status code, must be 302 (Found): " + httpResponse.getStatusCode());
        }
        URI location = httpResponse.getLocation();
        if (location == null) {
            throw new ParseException("Missing redirection URI / HTTP Location header");
        }
        return AuthorizationErrorResponse.parse(location);
    }

    static {
        stdErrors.add(OAuth2Error.INVALID_REQUEST);
        stdErrors.add(OAuth2Error.UNAUTHORIZED_CLIENT);
        stdErrors.add(OAuth2Error.ACCESS_DENIED);
        stdErrors.add(OAuth2Error.UNSUPPORTED_RESPONSE_TYPE);
        stdErrors.add(OAuth2Error.INVALID_SCOPE);
        stdErrors.add(OAuth2Error.SERVER_ERROR);
        stdErrors.add(OAuth2Error.TEMPORARILY_UNAVAILABLE);
    }
}

